package com.bcxin.backend.core.utils;

import com.alibaba.fastjson.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * HTTP 通讯工具类
 * @author Happy
 *
 */
public class HttpRequestUtil {
	
	/**
	 * 发起https Get请求并获取结果
	 * 
	 * @param requestUrl
	 *            请求地址
	 * @param outputStr
	 *            提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	public static JSONObject get(String requestUrl, String outputStr) throws Exception {
		return request(requestUrl, "GET", outputStr);
	}
	
	/**
	 * 发起https Post请求并获取结果
	 * 
	 * @param requestUrl
	 *            请求地址
	 * @param outputStr
	 *            提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	public static JSONObject post(String requestUrl,String outputStr) throws Exception {
		return request(requestUrl, "POST", outputStr);
	}

	/**
	 * 发起https Put请求并获取结果
	 *
	 * @param requestUrl
	 *            请求地址
	 * @param outputStr
	 *            提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	public static JSONObject put(String requestUrl,String outputStr) throws Exception {
		return request(requestUrl, "PUT", outputStr);
	}

	/**
	 * 发起https DELETE请求并获取结果
	 *
	 * @param requestUrl
	 *            请求地址
	 * @param outputStr
	 *            提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	public static JSONObject delete(String requestUrl,String outputStr) throws Exception {
		return request(requestUrl, "DELETE", outputStr);
	}
	
	/**
	 * 发起https请求并获取结果
	 * 
	 * @param requestUrl
	 *            请求地址
	 * @param requestMethod
	 *            请求方式（GET、POST）
	 * @param outputStr
	 *            提交的数据
	 * @return JSONObject(通过JSONObject.get(key)的方式获取json对象的属性值)
	 */
	private static JSONObject request(String requestUrl,
			String requestMethod, String outputStr)  throws Exception{
		JSONObject jsonObject = null;
		StringBuffer buffer = new StringBuffer();
		String message = "完成";
		try {
			URL url = new URL(requestUrl);
			HttpURLConnection httpUrlConn = (HttpURLConnection) url
					.openConnection();
			httpUrlConn.setDoOutput(true);
			httpUrlConn.setDoInput(true);
			httpUrlConn.setUseCaches(false);
			//httpUrlConn.setRequestProperty("Accept-Charset", "UTF-8");
			httpUrlConn.setRequestProperty("contentType", "UTF-8");
			// 设置请求方式（GET/POST）
			httpUrlConn.setRequestMethod(requestMethod);
			if ("GET".equalsIgnoreCase(requestMethod)){
				httpUrlConn.connect();
			}else{
				httpUrlConn.setRequestProperty("content-type", "application/json");
				httpUrlConn.setRequestProperty("dataType", "json");
			}

			// 当有数据需要提交时
			if (null != outputStr) {
				OutputStream outputStream = httpUrlConn.getOutputStream();
				// 注意编码格式，防止中文乱码
				outputStream.write(outputStr.getBytes("UTF-8"));
				outputStream.close();
			}

			// 将返回的输入流转换成字符串
			InputStream inputStream = httpUrlConn.getInputStream();
			InputStreamReader inputStreamReader = new InputStreamReader(
					inputStream, "utf-8");
			BufferedReader bufferedReader = new BufferedReader(
					inputStreamReader);

			String str = null;
			while ((str = bufferedReader.readLine()) != null) {
				buffer.append(str);
			}
			bufferedReader.close();
			inputStreamReader.close();
			// 释放资源
			inputStream.close();
			inputStream = null;
			httpUrlConn.disconnect();
			jsonObject = (JSONObject)JsonUtil.parseObject(buffer.toString());
		}catch (Exception e) {
			e.printStackTrace();
			message = ExceptionUtils.getStackMessage(e);
			if(e instanceof ConnectException)
			{
				throw new Exception("server connection timed out.");
			}

			throw new Exception("http request error:"+e.getMessage());
		}
		finally {
			JSONObject logParams = new JSONObject();
			logParams.put("requestUrl", requestUrl);
			logParams.put("requestMethod", requestMethod);
			logParams.put("outputStr", outputStr);
			logParams.put("error", message);
			logParams.put("response", jsonObject);
		}

		return jsonObject;
	}
}
