package com.bcxin.backend.core.exceptions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.OutputStream;
import java.io.PrintStream;

public class CustomSystemErrorPrintStream extends PrintStream {
    private static final Logger logger = LoggerFactory.getLogger(CustomSystemErrorPrintStream.class);
    public static CustomSystemErrorPrintStream instance = new CustomSystemErrorPrintStream(System.err);

    public CustomSystemErrorPrintStream(OutputStream out) {
        super(out);
    }

    @Override
    public void print(String s) {
        if (s != null && s.length() > 0) {
            logger.error(s);
        }
    }

    @Override
    public void println() {

        logger.error("\n");
    }

    @Override
    public void println(Object x) {
        super.println(x);
    }

    @Override
    public void println(String x) {

        super.println(x);
    }
}
