package com.bcxin.backend.core.components.commands;

import com.bcxin.backend.core.commands.CommandAbstract;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public class CreateHttpPostCommand extends CommandAbstract {
    private final String url;
    private final Map<String, Object> headers;
    private final Object body;

    public CreateHttpPostCommand(String url,
                                 Map<String, Object> headers, Object body) {
        this.url = url;
        this.headers = headers;
        this.body = body;
    }

    public CreateHttpPostCommand(String url, Object body) {
        this(url, new HashMap<>(), body);
    }

    @Override
    protected void validate() {

    }

    @Getter
    public static class CreateHttpPostCommandResult {
        private final int status;
        private final Map<String, Object> headers;
        private final Object body;

        public CreateHttpPostCommandResult(int status,
                                           Map<String, Object> headers,
                                           Object body) {
            this.status = status;
            this.headers = headers;
            this.body = body;
        }
    }
}
