package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.Shareholder;
import lombok.Data;

import java.util.Date;

/**
 *  保安服务公司设立股东信息
 */
@Data
public class ShareholderDto {
    //姓名
    private String item_shareholder;
    //出资金额（万元）
    private String item_capitalContribution;
    //股权所占比例
    private String item_stockProportion;
    //联系电话
    private String gdlxdh;

    /**
     * 返回股东信息
     * @return
     */
    public Shareholder convert(String taskId){
        Shareholder shareholder = new Shareholder();
        Date now = new Date();
        //表单需求数据
        shareholder.setId(StrUtil.join("--",taskId,OnlineTaskConstant.SHARE_HOLDER));
        shareholder.setCreated(now);
        shareholder.setLastmodified(now);
        shareholder.setIstmp(true);
        shareholder.setDomainid("__UDa4uPMdcOYgP7HETaf");
        shareholder.setFormid(OnlineTaskConstant.SHARE_HOLDER);
        shareholder.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        shareholder.setItemRegion("湖南省");
        //topId不在此处设置值
        //业务需求数据
        shareholder.setItemShareholder(this.item_shareholder);
        shareholder.setItemCapitalContribution(this.item_capitalContribution);
        shareholder.setItemStockProportion(this.item_stockProportion);
        shareholder.setItemPhone(this.getGdlxdh());
        return shareholder;
    }

}
