package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.CertificateService;
import com.baichuanxin.openrestapi.entity.Notice;
import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 *@Author duxiangyun
 *@Description   保安员资格证业务数据解析,formjson数据
 *@Date 2024/8/30
 */
@Data
public   class CertificateServiceDto {
    //申请人姓名
    private String name;
    //申请人身份号码
    private String certificateNum;
    //联系电话
    private String phone;
    //性别
    private String sex;
    //民族
    private String nation;
    //籍贯
    private String origoCountry;
    //出生年月  时间戳
    private String birthday;
    //文化程度
    private String item_education_2;
    //户籍地址
    private String addr;
    //政治面貌
    private String item_political_outlook;
    //考试区域
    private String item_exam_area;
    //工作单位或常住地址
    private String residence;
    //承诺上述填报信息真实有效
    private String item_premit_2;

    /***
     *@Author duxiangyun
     *@Description 申请审核数据
     *@Date 2024/9/2
     */
    public CertificateService convert(Notice notice){
        CertificateService certificateService = new CertificateService();
        Date now = new Date();
        //表单需求数据
        certificateService.setId(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.CERTIFICATE_SERVICE));
        certificateService.setCreated(now);
        certificateService.setLastmodified(now);
        certificateService.setFormname("");
        certificateService.setFormid(OnlineTaskConstant.CERTIFICATE_SERVICE);
        certificateService.setIstmp(true);
        certificateService.setApplicationid("__ebVTJ4Qkg61oQ2jlCCL");
        certificateService.setDomainid("__UDa4uPMdcOYgP7HETaf");
        certificateService.setItemRegion("湖南省");
        //办件数据
        certificateService.setTaskId(notice.getTaskId());
        //业务数据
        certificateService.setItemName(this.getName());
        certificateService.setItemDocumentId(OnlineTaskUtil.decrypt(this.getCertificateNum()));
        certificateService.setItemPhone(this.getPhone());
        certificateService.setItemNation(this.getNation());
        certificateService.setItemSex(this.getSex());

        AddressDto orignCountry = JSON.parseObject(this.getOrigoCountry(), AddressDto.class);
        certificateService.setItemNativePlace(orignCountry.convert());
        certificateService.setItemBirthday(DateUtil.getDateTime(this.getBirthday()));
        certificateService.setItemEducation(this.getItem_education_2());

        AddressDto addr = JSON.parseObject(this.getAddr(), AddressDto.class);
        certificateService.setItemResidenceAddress(addr.convert());
        certificateService.setItemPoliticalOutlook(this.getItem_political_outlook());
        AddressDto examArea = JSON.parseObject(this.getItem_exam_area(), AddressDto.class);

        String id = examArea.getRegion().get("id").toString();
        certificateService.setItemExamArea(id);


        certificateService.setItemBirthday(DateUtil.getDateTime(this.getBirthday()));
        AddressDto residence = JSON.parseObject(this.getResidence(), AddressDto.class);
        certificateService.setItemWorkAddress(residence.convert());
        certificateService.setItemPermit(this.getItem_premit_2());
        return certificateService;
    }
}
