package com.baichuanxin.openrestapi.service.impl;

import com.baichuanxin.openrestapi.dao.mapper.ECSysConfigMapper;
import com.baichuanxin.openrestapi.entity.ECSysConfig;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.service.ECSysconfigService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Base64;

@Slf4j
@Service
public class ECSysConfigServiceImpl extends ServiceImpl<ECSysConfigMapper, ECSysConfig> implements ECSysconfigService   {

    @Override
    public Boolean updateToken(String token) {
        UpdateWrapper<ECSysConfig> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("config_key", "hn_dzzz_get_token");
        updateWrapper.set("config_value", token);
        return this.update(updateWrapper);
    }

    @Override
    public ECSysConfig getOne() {
        QueryWrapper<ECSysConfig> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("config_key", "hn_dzzz_get_token");
        ECSysConfig one = this.getOne(queryWrapper);
        return one;
    }


}
