package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.entity.Attach;
import com.baichuanxin.openrestapi.entity.Notice;
import lombok.Data;

import java.util.*;


/***
 *@Author duxiangyun
 *@Description 申请附件转换
 *@Date 2024/8/24
 */
@Data
public class AttachDto {
    //事项材料 ID
    private String materialId;
    //事项材料名称
    private String materialName;
    //附件名称
    private String attachName;
    //附件地址
    private String attachPath;
    //附件类型（jpg、png等）;
    private String attachType;


    public Attach convert(Notice notice){
        Attach attach = new Attach();
        Date now =  new Date();
        attach.setId(StrUtil.join("--",
                StrUtil.join("_",notice.getTaskId(),this.getMaterialId()), OnlineTaskConstant.ATTACH));
        attach.setItemMaterials(JSON.toJSONString(this.getMaterials(notice)));
        attach.setItemApplyPaperId("");
        attach.setItemUploadApplyId("");
        attach.setItemApplyPaperName(this.getMaterialName());
        //表单需求数据
        attach.setCreated(now);
        attach.setLastmodified(now);
        attach.setApplicationid("__KDXZvc8mnEmDqMARhK7G");
        attach.setDomainid("__UDa4uPMdcOYgP7HETaf");
        attach.setFormid(OnlineTaskConstant.ATTACH);
        //topId插入数据时生成
        return attach;

    }
    public List<Map<String,Object>>   getMaterials(Notice notice){
        List<Map<String,Object>> lists = new ArrayList<>();
//        Map<String,Object>  map  = new HashMap<>();
//        map.put("uid","");
//        map.put("path",StrUtil.join("/","/uploads/onetask",notice.getMatId(),notice.getTaskId(),
//                this.getMaterialId(),StrUtil.join(".",this.getMaterialName(),this.getAttachType())));
//        map.put("originalPath",StrUtil.join("/","/uploads/onetask",notice.getMatId(),notice.getTaskId(),
//                this.getMaterialId(),StrUtil.join(".",this.getMaterialName(),this.getAttachType())));
//        map.put("name",StrUtil.join(".",this.getMaterialName(),this.getAttachType()));

        Map<String, Object> map = this.getMaterial(notice);
        lists.add(map);
        return lists ;
    }
    public Map<String,Object>   getMaterial(Notice notice){
        Map<String,Object>  map  = new HashMap<>();
        map.put("uid","");
        map.put("path",StrUtil.join("/","/uploads/onetask",notice.getMatId(),notice.getTaskId(),
                this.getMaterialId(),StrUtil.join(".",this.getMaterialName(),this.getAttachType())));
        map.put("originalPath",StrUtil.join("/","/uploads/onetask",notice.getMatId(),notice.getTaskId(),
                this.getMaterialId(),StrUtil.join(".",this.getMaterialName(),this.getAttachType())));
        map.put("name",StrUtil.join(".",this.getMaterialName(),this.getAttachType()));
        return map;
    }

}
