/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.utils;

public final class ExceptionUtils {
    public static <T extends Exception> T cast(Exception ex, Class<T> targetClass) {
        assert (ex != null);
        if (!targetClass.isAssignableFrom(ex.getClass())) {
            return null;
        }
        return (T)ex;
    }

    public static <T extends Exception> boolean is(Exception ex, Class<T> targetClass) {
        assert (ex != null);
        return targetClass.isAssignableFrom(ex.getClass());
    }

    public static String getStackMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        for (Throwable whileTr = throwable; whileTr != null; whileTr = whileTr.getCause()) {
            sb.append(String.format("exception=%s, detail=%s;", whileTr.getClass().getName(), whileTr.getMessage()));
        }
        return sb.toString();
    }
}

