/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.tracks;

public class RequestRouteTrack {
    private static final ThreadLocal<StringBuilder> tracking = new ThreadLocal();

    public static void reset() {
        tracking.set(new StringBuilder());
    }

    public static void push(String name, String message) {
        StringBuilder sb = RequestRouteTrack.getTrackingBuilder();
        sb.append(String.format("%s=%s;", name, message));
        sb.append(System.lineSeparator());
    }

    public static void push(String message) {
        StringBuilder sb = RequestRouteTrack.getTrackingBuilder();
        sb.append(message);
        sb.append(";");
        sb.append(System.lineSeparator());
    }

    public static String getAsResult() {
        return RequestRouteTrack.getTrackingBuilder().toString();
    }

    private static StringBuilder getTrackingBuilder() {
        StringBuilder sb = tracking.get();
        if (sb == null) {
            sb = new StringBuilder();
            tracking.set(sb);
        }
        return sb;
    }
}

