/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.configs.OneTaskConfig;
import com.baichuanxin.openrestapi.dao.mapper.SecurityServicekMapper;
import com.baichuanxin.openrestapi.dtos.AttachDto;
import com.baichuanxin.openrestapi.dtos.FileDto;
import com.baichuanxin.openrestapi.dtos.SecurityServicekDto;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.RegionCode;
import com.baichuanxin.openrestapi.entity.SecurityServicek;
import com.baichuanxin.openrestapi.service.TaskInfoService;
import com.baichuanxin.openrestapi.service.impl.AttachTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.ManagerInfoTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.RegionCodeServiceImpl;
import com.baichuanxin.openrestapi.service.impl.ShareholderTaskInfoServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecurityServicekTaskInfoServiceImpl
extends ServiceImpl<SecurityServicekMapper, SecurityServicek>
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(SecurityServicekTaskInfoServiceImpl.class);
    @Autowired
    private OneTaskConfig oneTaskConfig;
    @Autowired
    private AttachTaskInfoServiceImpl attachTaskInfoService;
    @Autowired
    private ShareholderTaskInfoServiceImpl shareholderTaskInfoService;
    @Autowired
    private ManagerInfoTaskInfoServiceImpl managerInfoTaskInfoService;
    @Autowired
    private RegionCodeServiceImpl regionCodeService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveTaskInfo(Notice notice) {
        Map formJson = notice.getFormJson();
        SecurityServicekDto securityServicekDto = (SecurityServicekDto)JSON.parseObject((String)JSON.toJSONString((Object)formJson), SecurityServicekDto.class);
        SecurityServicek securityServicek = securityServicekDto.convert(notice);
        RegionCode regionCode = this.regionCodeService.getRegionCode(securityServicek.getItemOfficePoliceAddress());
        securityServicek.setItemOfficePoliceAddress(regionCode.getName());
        securityServicek.setItemOfficePoliceAddressid(regionCode.getId());
        securityServicek.setItemOfficePoliceidindex(regionCode.getIndexTree());
        log.info("=====\u5224\u65ad\u6570\u636e\u662f\u5426\u5df2\u7ecf\u5b58\u5728:taskId:{}", (Object)notice.getTaskId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"taskId", (Object)notice.getTaskId());
        SecurityServicek one = (SecurityServicek)this.getOne((Wrapper)queryWrapper);
        if (one != null) {
            log.info("==\u6570\u636e\u5df2\u7ecf\u5b58\u5728:taskId:{}", (Object)notice.getTaskId());
            return true;
        }
        boolean saveResult = this.save((Object)securityServicek);
        boolean saveShareResult = this.shareholderTaskInfoService.saveOtherInfo(notice.getTaskId(), securityServicekDto.getItem_shareholder(), securityServicek.getID());
        boolean saveManageResult = this.managerInfoTaskInfoService.saveOtherInfo(notice.getTaskId(), securityServicekDto.getTxzyglry(), securityServicek.getID());
        boolean saveFileDataResult = this.attachTaskInfoService.saveOtherInfo(notice, securityServicek.getID());
        List attachList = notice.getAttachList();
        Map<String, List<AttachDto>> map = attachList.stream().collect(Collectors.groupingBy(AttachDto::getMaterialId));
        for (String key : map.keySet()) {
            List<AttachDto> attachDtos = map.get(key);
            int i = 1;
            for (AttachDto attachDto : attachDtos) {
                try {
                    FileHandleUtil.saveApplyFileHandle((String)StrUtil.join((CharSequence)"", (Object[])new Object[]{this.oneTaskConfig.getDownloadUrl(), attachDto.getAttachPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{attachDto.getMaterialName(), attachDto.getAttachType()})}));
                    ++i;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return saveResult && saveShareResult && saveManageResult && saveFileDataResult;
    }

    public List<String> returnTaskResult(List<Notice> noticeList) {
        ArrayList<String> taskList = new ArrayList<String>();
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (Notice notice : noticeList) {
            taskIdList.add(notice.getTaskId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"taskId", taskIdList);
        queryWrapper.in((Object)"ITEM_AUDITSTATUS", new Object[]{"0", "1"});
        List securityServicekList = this.list((Wrapper)queryWrapper);
        for (SecurityServicek securityServicek : securityServicekList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskId", securityServicek.getTaskId());
            map.put("userName", "\u6e56\u5357\u7701\u4fdd\u5b89\u76d1\u7ba1\u4fe1\u606f\u7cfb\u7edf");
            map.put("eventName", OnlineTaskUtil.convertStatus((String)securityServicek.getItemAuditStatus()));
            map.put("opinion", OnlineTaskUtil.convertStatus((String)OnlineTaskUtil.convertStatus((String)securityServicek.getItemAuditStatus())));
            map.put("endTime", DateUtil.dateFormatter((Date)securityServicek.getItemOverTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("isdelivery", securityServicek.getIsdelivery());
            log.info("\u53d1\u9001\u5ba1\u6838\u7ed3\u679c");
            boolean b = OnlineTaskUtil.returnResult((String)JSON.toJSONString(map));
            if (b) {
                taskList.add(securityServicek.getTaskId());
            }
            log.info("\u53d1\u9001\u7ed3\u679c\u7269");
            if (securityServicek.getItemAuditStatus() == "0") {
                boolean result0 = this.sentResultFile(securityServicek.getTaskId(), securityServicek.getItemAcceptanceFile(), "0");
                if (!b || !result0) continue;
                taskList.add(securityServicek.getTaskId());
                continue;
            }
            if (securityServicek.getItemAuditStatus() != "1") continue;
            boolean result = OnlineTaskUtil.returnResultFile((String)securityServicek.getTaskId(), (String)securityServicek.getItemCompanyName(), (File)FileHandleUtil.fileHandle((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), StrUtil.join((CharSequence)".", (Object[])new Object[]{securityServicek.getTaskId(), "zip"})})), (String)"2");
            if (!b || !result) continue;
            taskList.add(securityServicek.getTaskId());
        }
        return taskList;
    }

    public List<SecurityServicek> getUnGetEC() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"item_isec", (Object)"1");
        queryWrapper.eq((Object)"licenseStatus", (Object)"0");
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    public boolean updateLicenseStatus(String id, String status) {
        UpdateWrapper serviceUpdateWrapper = new UpdateWrapper();
        serviceUpdateWrapper.eq((Object)"id", (Object)id);
        serviceUpdateWrapper.set((Object)"licenseStatus", (Object)status);
        boolean updateStatus = this.update((Wrapper)serviceUpdateWrapper);
        return updateStatus;
    }

    public boolean updateStatusAndfile(String id, String status, String filePath) {
        UpdateWrapper serviceUpdateWrapper = new UpdateWrapper();
        serviceUpdateWrapper.set((Object)"licenseStatus", (Object)status);
        serviceUpdateWrapper.set((Object)"item_service_file", (Object)filePath);
        serviceUpdateWrapper.eq((Object)"id", (Object)id);
        boolean updateStatus = this.update((Wrapper)serviceUpdateWrapper);
        return updateStatus;
    }

    public boolean updateByFeedBack(String taskId, String filePath) {
        UpdateWrapper servicekUpdateWrapper = new UpdateWrapper();
        servicekUpdateWrapper.eq((Object)"taskId", (Object)taskId);
        servicekUpdateWrapper.set((Object)"item_notice_state", (Object)"\u5df2\u7b7e\u6536");
        servicekUpdateWrapper.set((Object)"item_reach_state", (Object)"\u5df2\u7b7e\u6536");
        servicekUpdateWrapper.set((Object)"item_service_state", (Object)"\u5df2\u7b7e\u6536");
        servicekUpdateWrapper.set((Object)"item_completion_state", (Object)"\u5df2\u7b7e\u6536");
        servicekUpdateWrapper.set((Object)"item_public_completion_file ", (Object)filePath);
        servicekUpdateWrapper.set((Object)"item_public_reach_file ", (Object)filePath);
        boolean status = this.update((Wrapper)servicekUpdateWrapper);
        return status;
    }

    public boolean sentResultFile(String taskID, String fileListString, String specialResultFile) {
        List fileDtos = JSON.parseArray((String)fileListString, FileDto.class);
        boolean resultNoticeFile = false;
        for (FileDto fileDto : fileDtos) {
            resultNoticeFile = OnlineTaskUtil.returnResultFile((String)taskID, (String)fileDto.getName(), (File)FileHandleUtil.fileHandle((String)FileHandleUtil.strHandle((String)this.oneTaskConfig.getFilePath(), (String)StrUtil.replace((CharSequence)fileDto.getPath(), (CharSequence)"\\", (CharSequence)""))), (String)specialResultFile);
        }
        return resultNoticeFile;
    }
}

