/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.apps.AppDefinition;
import com.bcxin.backend.domain.apps.TriggerDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class GetAppTaskJobServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(GetAppTaskJobServiceImpl.class);
    private final HttpClient httpClient;
    @Value(value="${myapps.domain.url}")
    private String URL;

    public GetAppTaskJobServiceImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Cacheable(value={"triggerList"})
    public List<TriggerDefinition> getApps() throws Exception {
        String GETAPPURL = this.URL + "/api/v2/runtime/definitions/apps";
        String TRIGGERSURL = this.URL + "/api/v2/runtime/definitions/apps/%s/triggers";
        ArrayList<TriggerDefinition> triggerList = new ArrayList<TriggerDefinition>();
        HashSet triggerSet = new HashSet();
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(GETAPPURL));
            String appsJsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() < 300) {
                List apps = JSONObject.parseArray((String)appsJsonStr, AppDefinition.class);
                if (!ObjectUtils.isEmpty((Object)apps)) {
                    apps.stream().forEach(appDefinition -> {
                        String format = String.format(TRIGGERSURL, appDefinition.getId());
                        boolean ok = false;
                        String tggResStr = null;
                        try {
                            HttpGet get = new HttpGet(format);
                            HttpResponse tggRes = this.httpClient.execute((HttpUriRequest)get);
                            tggResStr = EntityUtils.toString((HttpEntity)tggRes.getEntity());
                            ok = tggRes.getStatusLine().getStatusCode() < 300;
                        }
                        catch (Exception e) {
                            log.error("\u6267\u884c\u8bf7\u6c42({})\u53d1\u751f\u5f02\u5e38", (Object)format, (Object)e);
                        }
                        List list = new ArrayList();
                        if (ok) {
                            list = JSONObject.parseArray((String)tggResStr, TriggerDefinition.class);
                        } else {
                            log.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1ID(url={})\u51fa\u73b0\u5f02\u5e38:{}", (Object)format, (Object)tggResStr);
                        }
                        if (!ObjectUtils.isEmpty(list)) {
                            list.forEach(tir -> triggerSet.add(tir));
                        }
                    });
                    triggerList.addAll(triggerSet);
                }
            } else {
                log.error(appsJsonStr);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8fde\u63a5({})\u5931\u8d25\uff0c\u6267\u884c\u6e05\u9664\u7f13\u5b58", (Object)GETAPPURL, (Object)e);
            throw e;
        }
        return triggerList;
    }

    @CacheEvict(value={"triggerList"})
    public void cleanAppTaskIdsCache() {
        log.error("\u7f13\u5b58\u5df2\u6e05\u9664");
    }
}

