package com.bcxin.backend.jobs;

import com.bcxin.backend.documentSignatrures.DocumentSignatureProvider;
import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

/**
 * 文书签章功能
 */
@Component
@ConditionalOnProperty(prefix = "myapps.documentCertificate",name = "enable",havingValue = "true")
public class DocumentSignatureScheduleJob extends ScheduleJobAbstract{
    private final static Logger logger = LoggerFactory.getLogger(DocumentSignatureScheduleJob.class);
    private final SignatureConfigProperty signatureConfigProperty;

    public DocumentSignatureScheduleJob(SignatureConfigProperty signatureConfigProperty) {
        this.signatureConfigProperty = signatureConfigProperty;
    }

    @Scheduled(fixedDelay = 1 * 60 * 1000)
    public void prepareDocumentSignature() {
        Collection<DocumentSignatureProvider> documentSignatureProviders
                = this.getBeans(signatureConfigProperty.getSignatureAreaCodes(),
                DocumentSignatureProvider.class
        );
        if (CollectionUtils.isEmpty(documentSignatureProviders)) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getSignatureAreaCodes());
            return;
        }

        documentSignatureProviders.parallelStream().forEach(documentSignatureProvider -> {
            documentSignatureProvider.step1_push2Queue();
        });
    }

    @Scheduled(fixedDelay = 2 * 60 * 1000)
    public void doSignature() {
        Collection<DocumentSignatureProvider> documentSignatureProviders
                = this.getBeans(signatureConfigProperty.getSignatureAreaCodes(),
                DocumentSignatureProvider.class
        );
        if (CollectionUtils.isEmpty(documentSignatureProviders)) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getSignatureAreaCodes());
            return;
        }

        documentSignatureProviders.parallelStream().forEach(documentSignatureProvider -> {
            documentSignatureProvider.step2_doSignature();
        });
    }

    @Scheduled(fixedDelay = 30 * 60 * 1000)
    public void doForNonExistsDocument() {
        Collection<DocumentSignatureProvider> documentSignatureProviders
                = this.getBeans(signatureConfigProperty.getSignatureAreaCodes(),
                DocumentSignatureProvider.class
        );
        if (CollectionUtils.isEmpty(documentSignatureProviders)) {
            logger.error("找不到符合实现:{}", signatureConfigProperty.getSignatureAreaCodes());
            return;
        }

        documentSignatureProviders.parallelStream().forEach(documentSignatureProvider -> {
            documentSignatureProvider.step3_doExceptionData();
        });
    }
}
