package com.bcxin.backend.configs;

import com.bcxin.backend.core.AppConfigProperty;
import com.bcxin.backend.core.components.StorageProvider;
import com.bcxin.backend.domain.models.SuperviseDTO;
import com.bcxin.saas.core.components.JsonProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

import java.util.Collection;

@EnableScheduling
@Configuration
public class TaskConfig {

    @Bean
    @ConditionalOnMissingBean
    public JsonProvider jsonProvider() {
        return new JsonProvider.JsonProviderImpl();
    }

    @Bean
    public AppConfigProperty appConfigProperty(
            @Value("${myapps.storage.root}") String rootPath,
            @Value("${myapps.domain.url}") String domainUrl,
            @Value("${myapps.synced.proxied-targets:}") Collection<String> proxiedTargets,
            @Value("${myapps.out.requset-dir-key:}") String outRequsetDirKey) {
        return AppConfigProperty.create(rootPath, domainUrl, proxiedTargets,outRequsetDirKey);
    }

    @Bean("default.supervise")
    public SuperviseDTO defaultSuperviseDTO(
            @Value("${myapps.supervise.region-id:}")
                    String regionId,
            @Value("${myapps.supervise.system-admin:}")
                    String systemAdmin,
            @Value("${myapps.supervise.src-app:}")
                    String srcApp,
            @Value("${myapps.supervise.target-app:}")
                    String targetApp,
            @Value("${myapps.supervise.callback-url:}")
                    String callbackUrl,
            @Value("${myapps.supervise.target-service-url:}")
                    String targetServiceUrl) {
        SuperviseDTO superviseDTO = new SuperviseDTO();
        superviseDTO.setRegionId(regionId);
        superviseDTO.setSystemAdmin(systemAdmin);
        superviseDTO.setSrcApp(srcApp);
        superviseDTO.setTargetApp(targetApp);
        superviseDTO.setCallbackUrl(callbackUrl);
        superviseDTO.setTargetServiceUrl(targetServiceUrl);

        return superviseDTO;
    }

    @Bean
    public StorageProvider storageProvider(AppConfigProperty appConfigProperty) {
        return new StorageProvider.StorageProviderImpl(appConfigProperty);
    }


    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(50);
        return taskScheduler;
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClientBuilder.create().build();
    }
}
