package com.bcxin.backend.certificateSignatures.impls;

import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Qualifier("beijing")
public class CertificatePushProvider_Beijing extends CertificatePushProvider_Abstract {
    private static final Logger logger = LoggerFactory.getLogger(CertificatePushProvider_Beijing.class);


    public CertificatePushProvider_Beijing(SignatureQueuesRepository signatureQueuesRepository,
                                           SignatureQueuesDocumentRepository signatureQueuesDocumentRepository,
                                           @Value("${myapps.signature.ferry_outside}") String ferryOutside,
                                           @Value("${myapps.signature.ferry_inside}") String ferryInside,
                                           @Qualifier("primaryJdbcTemplate")JdbcTemplate jdbcTemplate,
                                           @Value("${myapps.domain.url}") String urlHead,
                                           @Value("${myapps.storage.root}") String rootPath,
                                           ThreadPoolTaskExecutor taskExecutor, HttpClient httpClient
                                           ) {
        super(signatureQueuesRepository, signatureQueuesDocumentRepository, jdbcTemplate, ferryOutside, ferryInside,
                urlHead, rootPath, taskExecutor, httpClient);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
