package com.bcxin.backend.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.backend.configs.SmsConfig;
import com.bcxin.backend.dto.HuaWeiSmsContent;
import com.bcxin.backend.dto.SmsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class MessageUtil {
	final static Logger logger = LoggerFactory.getLogger(MessageUtil.class);

	/**
	 * 发送华为短信
	 * @param huaWeiSmsContent
	 * @return
	 */
	public static boolean sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		boolean flag = false;
		Map<String,Object> params =  new HashMap<>();
		//环境标识
        huaWeiSmsContent.setChannel(SmsConfig.getChannel());
		huaWeiSmsContent.setPlatform(SmsConfig.getPlatform());
		params.put("data", JSON.toJSONString(huaWeiSmsContent));
		params.put("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.formatDate(DateUtil.date())));
		String result = HttpUtil.post(SmsConfig.getUrl(),params);

		SmsResult smsResult = JSON.parseObject(result,SmsResult.class);
		flag = smsResult.isSuccess();
		System.out.println(result);
		logger.info(result);

		return flag;
	}
	public static void testSendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		Map<String,Object> params =  new HashMap<>();
		//环境标识
		params.put("data", JSON.toJSONString(huaWeiSmsContent));
		params.put("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.formatDate(DateUtil.date())));
		String result = HttpUtil.post("http://msg.ba.baibaodun.com.cn:9165/sms/huawei/sendSMS",params);
		System.out.println(result);
		logger.info(result);
	}
}
