package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.common.QzConstant;
import com.bcxin.backend.domain.signature.service.BeiJingInJTLZSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 京通靓证业务废止读取ftp外到内.bcx文件处理结果，每5分钟检索一次
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJTLZFZUseTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;
    private final BeiJingInJTLZSignature beiJingInJTLZSignature;

    public SignatureJTLZFZUseTask(BeiJingInJTLZSignature beiJingInJTLZSignature) {
        this.beiJingInJTLZSignature = beiJingInJTLZSignature;
    }


    @Override
    protected void runCore() {
        if(QzConstant.QZ_SIGNATURE_SERVER_KEY_BEIJINGIN.equals(serverKey)){
            //京通靓证业务读取ftp外到内.bcx文件处理结果
            beiJingInJTLZSignature.useJTLZFZ();
        }
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.jtlzfz.use";
    }

}
