package com.bcxin.backend.documentSignatrures;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Getter
@Component
public class SignatureConfigProperty {

    /**
     * 所在的企业编码
     */
    @Value("${myapps.sysCode:}")
    private String areaCode;

    @Value("${myapps.domain.url}")
    private String urlHead;
    @Value("${myapps.signature.unSignaturePDF}")
    private String unSignatureSignatureToPDFServiceImplPDF;
    @Value("${myapps.signature.signaturePDF}")
    private String signaturePDF;
    @Value("${myapps.signature.tempPDF}")
    private String tempPDF;
    @Value("${myapps.signature.cgiApi}")
    private String cgiApi;

    @Value("${myapps.storage.root}")
    private String rootPath;

    @Value("${myapps.signature.areaCodes:}")
    private Collection<String> signatureAreaCodes;


    public String getDocumentOutPath(String fileName) {
        return String.format("%s/document/%s", tempPDF.replace("temp", "out"), fileName);
    }

    public String getDocumentErrorPath(String fileName) {
        return String.format("%s/document/%s", tempPDF.replace("temp", "error"), fileName);
    }
}
