package com.bcxin.backend.certificateSignatures.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.certificateSignatures.CertificatePushProvider;
import com.bcxin.backend.certificateSignatures.impls.values.pushCertificates.CertificateCallBackValueType;
import com.bcxin.backend.core.edis.EDIConstants;
import com.bcxin.backend.core.edis.EDIFileValue;
import com.bcxin.backend.core.edis.JTLZResponseValueEDI;
import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.models.SignatureQueuesDocument;
import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.signature.service.impls.BeiJingInJTLZServiceImpl;
import com.bcxin.backend.domain.utils.FileUtils;
import com.bcxin.backend.domain.utils.JTLZBodyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public abstract class CertificatePushProvider_Abstract implements CertificatePushProvider {

    private final SignatureQueuesRepository signatureQueuesRepository;
    private final SignatureQueuesDocumentRepository signatureQueuesDocumentRepository;

    private final JdbcTemplate jdbcTemplate;
    private final String ferryOutside;//外网进来文件存放地址

    private final String ferryInside;//内网出去文件存放地址
    private final String urlHead;
    private final String rootPath;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final HttpClient httpClient;

    protected CertificatePushProvider_Abstract(SignatureQueuesRepository signatureQueuesRepository,
                                               SignatureQueuesDocumentRepository signatureQueuesDocumentRepository,
                                               JdbcTemplate jdbcTemplate,
                                               String ferryOutside,
                                               String ferryInside,
                                               String urlHead,
                                               String rootPath,
                                               ThreadPoolTaskExecutor taskExecutor, HttpClient httpClient) {
        this.signatureQueuesRepository = signatureQueuesRepository;
        this.signatureQueuesDocumentRepository = signatureQueuesDocumentRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.ferryOutside = ferryOutside;
        this.urlHead = urlHead;
        this.rootPath = rootPath;
        this.taskExecutor = taskExecutor;
        this.httpClient = httpClient;
        this.ferryInside = ferryInside;
    }

    @Override
    public void push2CertificateCenter() {
        cn.hutool.core.date.StopWatch stopWatch = new cn.hutool.core.date.StopWatch();
        Exception lastException = null;
        StringBuilder sb = new StringBuilder();
        try {
            stopWatch.start();
            //最后修改时间在5分钟内的通过记录 TODO 当前只查询资格证数据处理，还需要查询保安服务许可证数据
            Page<SignatureQueuesDTO> pageQueues =
                    signatureQueuesRepository.pageQueuesBy5Minute(1, PageRequest.of(0, 150));
            List<SignatureQueuesDTO> queues = pageQueues.getContent();
            Snowflake snowflake = IdUtil.createSnowflake(1, 1);
            Collection<String> processedFileNames = new ArrayList<>();
            AtomicInteger errorCountRef = new AtomicInteger(0);
            sb.append(String.format("获取到的JTLZ数量=%s;", queues.size()));

            CountDownLatch downLatch = new CountDownLatch(queues.size());
            for (SignatureQueuesDTO dto : queues) {
                this.taskExecutor.execute(() -> {
                    try {
                        if (StringUtils.isEmpty(dto.getData()) || StringUtils.isEmpty(dto.getBusiness_id())) {
                            throw new SaasBadException("签章记录数据缺失");
                        }
                        String sql = "SELECT item_attachment FROM tlk_certificate WHERE id = '" + dto.getBusiness_id() + "';";
                        List<String> attachment = jdbcTemplate.query(sql, new RowMapper<String>() {
                            @Override
                            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                                return rs.getString("item_attachment");
                            }
                        });

                        if (attachment.size() == 0 || StringUtils.isEmpty(attachment.get(0))) {
                            signatureQueuesRepository.updateSignature(0, new Date(), "原电子证书文件丢失，重新签章", dto.getId());
                            return;
                        }
                        String pdfUrl = urlHead + attachment.get(0);
                        String path = rootPath + attachment.get(0);
                        Path path1 = Paths.get(path);
                        String fileName = path1.getFileName().toString();
                        String extension = "";
                        int dotIndex = fileName.lastIndexOf('.');
                        if (dotIndex != -1) {
                            extension = fileName.substring(dotIndex + 1);
                        }

                        String base64 = FileUtils.urlToBase64(httpClient, pdfUrl);
                        if (StringUtils.isEmpty(base64)) {
                            throw new SaasBadException("电子证书转换base64失败：" + pdfUrl);
                        }

                        BeiJingInJTLZServiceImpl.SignatureData signatureData = JSONObject.parseObject(dto.getData(), BeiJingInJTLZServiceImpl.SignatureData.class);
                        JSONObject data_field = new JSONObject();
                        data_field.put("ZZMC", "中华人民共和国保安员证");
                        data_field.put("CYRMC", signatureData.getName());
                        data_field.put("FZJGZZJGDM", "1111000000002888XF");//发证机构唯一标识
                        data_field.put("FZJGSSXZQHDM", "110000");//发证机构所属行政区划代码
                        data_field.put("CYRSFZJLX", "10");
                        data_field.put("CYRSFZJHM", signatureData.getIdcardno().toUpperCase());
                        data_field.put("FZRQ", DateUtil.formatDate(DateUtil.parseDate(signatureData.getFzDate())));
                        data_field.put("YXQJSRQ", "");
                        data_field.put("CSRQ", signatureData.getYear() + "年" + signatureData.getMonth() + "月" + signatureData.getDay() + "日");
                        data_field.put("ZZ", signatureData.getAddress());
                        data_field.put("ZP", "");
                        data_field.put("ZZHM", signatureData.getCertificateno());
                        data_field.put("FZJGMC", StringUtils.isEmpty(signatureData.getCertificatefrom()) ? "北京市公安局" : signatureData.getCertificatefrom());
                        getLogger().info("========> createJTLZ.SignatureQueuesDTO：data_field：{}", JSON.toJSONString(data_field));
                        BeiJingInJTLZServiceImpl.OperatorData operatorData = BeiJingInJTLZServiceImpl.OperatorData.fixedOperatorData();
                        List<BeiJingInJTLZServiceImpl.FileData> fileDataList = new ArrayList<>();
                        fileDataList.add(
                                new BeiJingInJTLZServiceImpl.FileData(fileName, extension, base64, "附件为" + signatureData.getName() + "（编号：" + signatureData.getCertificateno() + "）的电子资格证。")
                        );

                        String bodyContent =
                                JTLZBodyUtil.license_issue(
                                        EDIConstants.CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SERVICE_CODE,
                                        EDIConstants.CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SERVICE_NAME,
                                        EDIConstants.CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SEAL_CODE,
                                        data_field, operatorData,
                                        fileDataList);
                        // 内到外文件名规则：IN-JTLZ-01-1111-101.bcx（内网-京通靓证-资格证编码-itemcode-业务id）
                        String fName = EDIConstants.getJTLZFileName(String.valueOf(dto.getId()), snowflake.nextIdStr());
                        processedFileNames.add(fName);
                        FileUtils.writeFile(ferryInside, fName, bodyContent);
                        signatureQueuesRepository.updateResult(new Date(), "靓证中", dto.getId());
                    } catch (Exception e) {
                        errorCountRef.incrementAndGet();
                        getLogger().error("========> createJTLZ.SignatureQueuesDTO.server.error: 【ID:{}】", dto.getId(), e);
                    } finally {
                        downLatch.countDown();
                    }
                });
            }

            try {
                downLatch.await();
            } catch (Exception ex) {
                getLogger().error("downLatch.await() exception", ex);
            }

            sb.append(String.format("errorSize=%s;", errorCountRef.get()));
            if (processedFileNames.size() > 0) {
                String writeFtpName = EDIConstants.getSummaryFileName();
                String body = String.join(",", processedFileNames);
                getLogger().error("========> createJTLZ.file：writeFtpName：" + writeFtpName + " ，文件个数: " + processedFileNames.size() + " ---");
                FileUtils.writeFile(ferryInside, writeFtpName, body);
            }
        } catch (Exception ex) {
            lastException = ex;
            throw ex;
        } finally {
            stopWatch.stop();

            getLogger().error("{}-Done for createJTLZ.SignatureQueuesDTO cost{} seconds; trace={}",
                    (lastException == null ? "Success" : "Error"),
                    stopWatch.getTotalTimeSeconds(), sb, lastException);
        }
    }

    @Override
    public void doneForCallback() {
        Exception topException = null;
        StopWatch topWatch = new StopWatch();
        topWatch.start();

        StringBuilder track = new StringBuilder();

        try {
            Collection<CertificateCallBackValueType>
                    certificateCallBacks = getCallbackValues();

            if (CollectionUtils.isEmpty(certificateCallBacks)) {
                track.append("取到的回调为0;");
                getLogger().warn("【警告】暂无获取到签章的回传内容信息");
                return;
            }
            track.append(String.format("回调数量=%s;", certificateCallBacks.size()));

            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Exception lastException = null;
            try {
                Collection<CertificateCallBackValueType> certificate01Data =
                        certificateCallBacks.stream()
                                .filter(ii ->
                                        ii.getStatus() != CertificateCallBackValueType.CertificateCallBackStatus.Exception &&
                                        ii.match(CertificateCallBackValueType.CertificateValueType.Certificate)
                                ).collect(Collectors.toList());

                /**
                 * 资格证的会掉信息
                 */
                if (!CollectionUtils.isEmpty(certificate01Data)) {
                    Collection<Long> ids = certificate01Data.stream()
                            .map(ii -> {
                                try{
                                    /**
                                     * 只有long才是有效的格式
                                     */
                                    Long queueId = Long.parseLong(ii.getQueueId());
                                    return queueId;
                                }catch (Exception ex){
                                    getLogger().error("Unexpected  queue.type ({}=>Long)",ii.getQueueId(),ex);
                                }
                                return null;
                            }).filter(ii->ii!=null).collect(Collectors.toList());
                    track.append(String.format("certificate01Data.ids=%s;", ids.stream().map(ii->String.valueOf(ii)).collect(Collectors.joining(","))));

                    Collection<SignatureQueuesDTO> signatureQueues = this.signatureQueuesRepository.findAllById(ids);
                    if (!CollectionUtils.isEmpty(signatureQueues)) {
                        StopWatch subTopWatch = new StopWatch();
                        subTopWatch.start();
                        for (SignatureQueuesDTO signature : signatureQueues) {
                            CertificateCallBackValueType matchOne = getPreferMatchCertificateCallBack(certificate01Data, String.valueOf(signature.getId()));
                            signature.setJt_code(matchOne.getCode());
                            signature.setLast_processed_time(new Date());
                            signature.setLast_processed_result(matchOne.getMessage());
                        }

                        this.signatureQueuesRepository.saveAll(signatureQueues);

                        subTopWatch.stop();

                        track.append(String.format("signatureQueues.save=%s;%s秒;", signatureQueues.size(), subTopWatch.getTotalTimeSeconds()));

                    } else {
                        track.append("资格证为空;");
                        getLogger().error("【非预期回调】处理资格证回调的时候找不到预期数据:预期={},",
                                ids.stream().map(ii -> String.format("'%s'", ii)).collect(Collectors.joining()), "EMPTY");
                    }
                }
                /**
                 * 文书签章的信息
                 */
                Collection<CertificateCallBackValueType> documentCertificate15Data =
                        certificateCallBacks.stream()
                                .filter(ii -> ii.getStatus() != CertificateCallBackValueType.CertificateCallBackStatus.Exception &&
                                        ii.match(CertificateCallBackValueType.CertificateValueType.DocumentCertificate))
                                .collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(documentCertificate15Data)) {
                    Collection<Long> ids =
                            documentCertificate15Data.stream()
                            .map(ii -> {
                                try{
                                    /**
                                     * 只有long才是有效的格式
                                     */
                                    Long queueId = Long.parseLong(ii.getQueueId());
                                    return queueId;
                                }catch (Exception ex){
                                    getLogger().error("Unexpected queue.document type ({}=>Long)",ii.getQueueId(),ex);
                                }
                                return null;
                            })
                            .filter(ii->ii!=null)
                            .collect(Collectors.toList());

                    track.append(String.format("documentCertificate15Data.ids=%s;",
                            ids.stream().map(ii->String.valueOf(ii))
                                    .collect(Collectors.joining(","))));

                    Collection<SignatureQueuesDocument> signatureQueuesDocuments = this.signatureQueuesDocumentRepository.findAllById(ids);
                    if (!CollectionUtils.isEmpty(signatureQueuesDocuments)) {

                        StopWatch subTopWatch = new StopWatch();
                        subTopWatch.start();

                        for (SignatureQueuesDocument document : signatureQueuesDocuments) {
                            CertificateCallBackValueType matchOne =
                                    getPreferMatchCertificateCallBack(documentCertificate15Data, String.valueOf(document.getId()));
                            if (matchOne != null) {
                                document.setJt_code(matchOne.getCode());
                                document.setLastmodified(new Date());
                                document.setProcessed_result(matchOne.getMessage());
                            } else {
                                getLogger().error("无效的document.id={}", document.getId());
                            }
                        }

                        this.signatureQueuesDocumentRepository.saveAll(signatureQueuesDocuments);

                        subTopWatch.stop();
                        track.append(String.format("signatureQueuesDocuments.save=%s;%s秒;", signatureQueuesDocuments.size(), subTopWatch.getTotalTimeSeconds()));
                    } else {
                        track.append("文书为空;");
                        getLogger().error("【非预期回调】处理文书信息回调的时候找不到预期数据:预期={},", ids.stream().map(ii -> String.format("'%s'", ii)).collect(Collectors.joining()), "EMPTY");
                    }
                }
            } catch (Exception ex) {
                lastException = ex;
                throw ex;
            } finally {
                stopWatch.stop();
                getLogger().error("{} - 签章数据推送结束:size={}; 耗时{}秒",
                        (lastException == null ? "Success" : "Error"), certificateCallBacks.size(), stopWatch.getTotalTimeSeconds(),
                        lastException
                );

                track.append("完成;");
                Collection<File> carrierFiles = null;
                try {
                    carrierFiles =
                            certificateCallBacks.stream()
                                    .map(ii -> (File) ii.getDataCarrier()).distinct()
                                    .collect(Collectors.toList());
                    for (File toDeleteFile : carrierFiles) {
                        try {
                            FileUtil.del(toDeleteFile);
                        } catch (Exception ex) {
                            getLogger().error("删除文件发生异常:{}:{}", toDeleteFile.getPath(), ex.getMessage());
                        }
                    }

                    getLogger().error("SUCCESS-BATCH-DELETE OUT文件-{}",
                            (carrierFiles == null ? "EMPTY" : carrierFiles.stream().map(ii -> ii.getName()).collect(Collectors.joining(","))));

                    track.append("完成删除;");
                } catch (Exception ex) {
                    track.append("异常删除;");
                    getLogger().error("ERROR-BATCH-DELETE 发生异常:{}:{}", (carrierFiles == null ? "NULL" : carrierFiles.size()), ex.getMessage());
                }
            }
        } catch (Exception ex) {
            topException = ex;

            throw ex;
        } finally {
            topWatch.stop();

            getLogger().error("{} Done for total doneForCallback:cost {} seconds; track={}",
                    (topException == null ? "SUCCESS" : "ERROR"),
                    topWatch.getTotalTimeSeconds(), track, topException);
        }
    }

    protected abstract Logger getLogger();

    protected CertificateCallBackValueType getPreferMatchCertificateCallBack(
            Collection<CertificateCallBackValueType>  data,
            String id) {
        CertificateCallBackValueType matchOne =
                data.stream()
                        .filter(ii -> id.equalsIgnoreCase(ii.getQueueId()) && ii.getStatus() == CertificateCallBackValueType.CertificateCallBackStatus.OK)
                        .findFirst().orElse(null);

        if (matchOne == null) {
            matchOne = data.stream().filter(ii -> ii.getQueueId().equalsIgnoreCase(id)).findFirst().orElse(null);
        }

        return matchOne;
    }

    /**
     * 即将被替换为: extractBatchFileData
     * 减少不必要的文件数量
     * @param file
     * @return
     */
    @Deprecated
    protected CertificateCallBackValueType extractData(File file) {
        EDIFileValue ediFileValue = parseEDIFile(file.getName());
        getLogger().error("====> 解析靓证结果定时任务.updateJTLZ.filename：{}" , file.getName());
        if (!"01".equals(ediFileValue.getType()) && !"15".equals(ediFileValue.getType())) {
            getLogger().error("====> 解析靓证结果定时任务.updateJTLZ.filename：文件类型不存在");
            return CertificateCallBackValueType.error(
                    CertificateCallBackValueType.CertificateCallBackStatus.Exception,
                    file,
                    false,
                    "文件类型不存在"
            );
        }

        String content = FileUtil.readString(file, StandardCharsets.UTF_8);

        return getCertificateCallBackValueType(ediFileValue.getId(), content, ediFileValue.getType(), file,false);
    }

    protected Collection<CertificateCallBackValueType> extractBatchFileData(File batchFile) {
        String content = FileUtil.readString(batchFile, StandardCharsets.UTF_8);
        getLogger().error("====> 解析靓证结果定时任务.updateJTLZ.filename：{}" , batchFile.getName());

        Collection<JTLZResponseValueEDI> edis =
                JSONObject.parseArray(content, JTLZResponseValueEDI.class);
        if (CollectionUtils.isEmpty(edis)) {
            getLogger().error("解析到的edis内容为空:{}", batchFile);
            return Collections.EMPTY_LIST;
        }

        Collection<CertificateCallBackValueType> certificateCallBackValueTypes = edis.stream().map(ii -> {
            EDIFileValue ediFileValue = parseEDIFile(ii.getFileName());

            return getCertificateCallBackValueType(ediFileValue.getId(), ii.getResponse(), ediFileValue.getType(), batchFile,true);
        }).collect(Collectors.toList());

        return certificateCallBackValueTypes;
    }

    protected Collection<CertificateCallBackValueType> getCallbackValues() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Exception lastException = null;

        StringBuilder trace = new StringBuilder();
        int totalCount = 0;
        try {
            trace.append("step1;");
            List<File> files = FileUtils.filenames(ferryOutside, EDIConstants.PUSH_CALLBACK_OUT_FILE_PREFIX);
            List<File> batchFiles = FileUtils.filenames(ferryOutside, EDIConstants.PUSH_BATCH_CALLBACK_OUT_FILE_PREFIX);
            trace.append("step2;");
            if (files == null) {
                trace.append("step2.1;");
                files = new ArrayList<>();
            }
            if (batchFiles == null) {
                trace.append("step2.2;");
                batchFiles = new ArrayList<>();
            }

            trace.append(String.format("file.size=%s;batchFile.size=%s;", files.size(), batchFiles.size()));

            if (CollectionUtils.isEmpty(files) && CollectionUtils.isEmpty(batchFiles)) {
                return Collections.EMPTY_LIST;
            }

            trace.append("step3;");
            StopWatch subStopWatch = new StopWatch();
            subStopWatch.start();
            Collection<CompletableFuture<CertificateCallBackValueType>> futures =
                    files.stream().map(ii -> {
                        return CompletableFuture.supplyAsync(() -> {
                            return extractData(ii);
                        });
                    }).collect(Collectors.toList());

            trace.append("step4;");
            Collection<CompletableFuture<Collection<CertificateCallBackValueType>>> batchFutures =
                    batchFiles.stream().map(ii -> {
                        return CompletableFuture.supplyAsync(() -> {
                            return extractBatchFileData(ii);
                        });
                    }).collect(Collectors.toList());

            trace.append("step5;");
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
            trace.append("step6;");
            CompletableFuture.allOf(batchFutures.toArray(new CompletableFuture[batchFutures.size()])).join();
            subStopWatch.stop();
            trace.append(String.format("step7-cost %s 秒;", subStopWatch.getTotalTimeSeconds()));
            /**
             * 即将被删除
             */
            Collection<CertificateCallBackValueType> data = futures.stream().map(ii -> {
                try {
                    return ii.get();
                } catch (Exception ex) {
                    getLogger().error("解析OUT响应文件发生异常", ex);
                }

                return null;
            }).filter(ii -> ii != null).collect(Collectors.toList());

            trace.append("step8;");
            Collection<CertificateCallBackValueType> batchData = batchFutures.stream().map(ii -> {
                        try {
                            return ii.get();
                        } catch (Exception ex) {
                            getLogger().error("解析Batch-OUT响应文件发生异常", ex);
                        }

                        return null;
                    }).filter(ii -> ii != null)
                    .flatMap(ii -> ii.stream())
                    .collect(Collectors.toList());
            trace.append("step9;");
            data.addAll(batchData);
            trace.append("step10；");

            totalCount = data.size();

            return data;
        } catch (Exception ex) {
            lastException = ex;

            throw ex;
        } finally {
            stopWatch.stop();

            getLogger().error("{} Done for getCallbackValues(size={}) with trace={}; cost {} seconds",
                    (lastException == null ? "SUCCESS" : "ERROR"),
                    totalCount,
                    trace, stopWatch.getTotalTimeSeconds(), lastException);
        }
    }

    private CertificateCallBackValueType getCertificateCallBackValueType(String id, String content,String type,File file,boolean batchContent) {
        try {
            if (StringUtils.isEmpty(content)) {
                String message = "靓证失败，请手动设置最后修改时间为当前进行重试";

                return CertificateCallBackValueType.create(
                        CertificateCallBackValueType.CertificateCallBackStatus.Error,
                        id,
                        null,
                        "",
                        type,
                        file,
                        batchContent,
                        message
                );
            }

            JSONObject json = JSONObject.parseObject(content);
            if ("FAILURE".equals(json.getString("ack_code"))) {
                String errJson = json.getString("errors");
                if (errJson.contains(EDIConstants.MESSAGE_DUPLICATE_CERTIFICATE_DOCUMENT)) {
                    String jtCode = id + "YES";
                    return CertificateCallBackValueType.create(
                            CertificateCallBackValueType.CertificateCallBackStatus.OK,
                            id,
                            null,
                            jtCode,
                            type,
                            file, batchContent,
                            "完成靓证:存在重复的电子证照（无需重新靓证）"
                    );
                }
                if ("[]".equals(errJson)) {
                    return CertificateCallBackValueType.create(
                            CertificateCallBackValueType.CertificateCallBackStatus.Error,
                            id,
                            null,
                            "",
                            type,
                            file, batchContent,
                            "靓证失败:异常信息为空"
                    );
                }
                JSONArray jsonArray = JSONArray.parseArray(errJson);
                JSONObject errObj = (JSONObject) jsonArray.get(0);
                return CertificateCallBackValueType.create(
                        CertificateCallBackValueType.CertificateCallBackStatus.Error,
                        id,
                        null,
                        "",
                        type,
                        file, batchContent,
                        "靓证失败" + errObj.getString("message")
                );
            }

            JSONObject data = json.getObject("data", JSONObject.class);
            String jtcode = data.getString("auth_code");
            if (StringUtils.isEmpty(jtcode)) {
                return CertificateCallBackValueType.create(
                        CertificateCallBackValueType.CertificateCallBackStatus.Error,
                        id,
                        null,
                        "",
                        type,
                        file, batchContent,
                        "靓证失败:靓证编号丢失"
                );
            }

            return CertificateCallBackValueType.create(
                    CertificateCallBackValueType.CertificateCallBackStatus.OK,
                    id,
                    null,
                    jtcode,
                    type,
                    file, batchContent,
                    "完成靓证"
            );
        } catch (Exception ex) {
            getLogger().error("getCertificateCallBackValueType 获取数据发生异常:{}", file.getName(), ex);
            throw ex;
        }
    }

    private EDIFileValue parseEDIFile(String fileName) {
        String[] arr = fileName.replace(EDIConstants.PUSH_FILE_EXTENSION, "").split("-");
        String type = arr[2];
        String id = arr[4];
        if (id.contains("N")) {
            id = id.split("N")[0];
        }

        return EDIFileValue.create(id, type);
    }
}
