package com.bcxin.backend.strategy.bg.impl;

import com.bcxin.backend.dto.bg.BgScreeningParams;
import com.bcxin.backend.dto.bg.BgScreeningResultDto;
import com.bcxin.backend.strategy.bg.BgScreeningStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * description: 模拟背筛比对策略
 * author: linchunpeng
 * date:  2023-07-14 9:59
 */
@Slf4j
@Service
public class MockBgScreeningCompare extends BaseBgScreeningCompare implements BgScreeningStrategy {

    /**
     * description: 执行背筛比对
     * author: linchunpeng
     * date:  2023-07-14 10:00
     */
    @Override
    public List<BgScreeningResultDto> executeBgScreening(BgScreeningParams params) {
        List<BgScreeningResultDto> resultDtoList = new ArrayList<>();
        for (String idnum : params.getBgUserIdnumList()) {
            //循环背筛身份证列表，单个进行模拟背筛、、
//            if(idnum.endsWith("5")){
//                //身份证位数为5,模拟为：调用接口失败
//                log.info("身份证号：{}，调用背筛接口失败", idnum);
//            } else {
                String apiResult = "";
                if(idnum.endsWith("1")){
                    //身份证位数为1,模拟为：吸毒人员
                    apiResult = this.getMockXiDu(idnum);
                } else if(idnum.endsWith("2")){
                    //身份证位数为2,模拟为：在逃人员
                    apiResult = this.getMockZaiTao(idnum);
                } else if(idnum.endsWith("3")){
                    //身份证位数为3,模拟为：有违法犯罪记录
                    apiResult = this.getMockWeiFa(idnum);
                } else if(idnum.endsWith("4")){
                    //身份证位数为4,模拟为：吸毒人员、在逃人员、有违法犯罪记录
                    apiResult = this.getMockXiDuAndZaiTaoAndWeiFa(idnum);
                } else {
                    //其他的，模拟为：正常
                    apiResult = this.getMockNormal(idnum);
                }
                log.info("身份证号：{}，调用背筛接口，状态：{}，返回值：{}", idnum, 200, apiResult);
                //请求成功
                log.info("身份证号：{}，调用背筛接口成功", idnum);
                BgScreeningResultDto resultDto = super.getResultDtoByApiResult(apiResult);
                resultDto.setIdnum(idnum);
                if (resultDto.getIsProblem() != null) {
                    resultDtoList.add(resultDto);
                }
//            }
        }
        return resultDtoList;
    }

    /**
     * description: 模拟吸毒接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockXiDu(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"戒毒所人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"吸毒人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟在逃接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockZaiTao(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"全国在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟有违法犯罪记录接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockWeiFa(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"违法行为人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"有违法犯罪记录\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟有违法犯罪记录接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockXiDuAndZaiTao(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"戒毒所人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"全国在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"吸毒人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟有违法犯罪记录接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockXiDuAndWeiFa(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"戒毒所人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"违法行为人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"吸毒人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"违法犯罪（部下发重大犯罪前科）\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟有违法犯罪记录接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockXiDuAndZaiTaoAndWeiFa(String idnum) {
        Random random = new Random();
        int randomInt = random.nextInt(101);
        if (randomInt%2 == 0) {
            return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"戒毒所人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"全国在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"违法行为人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
        }
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[{\"code\":200,\"data\":{\"detail\":\"吸毒人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"在逃人员\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"},{\"code\":200,\"data\":{\"detail\":\"有违法犯罪记录\"},\"wffzry\":null,\"result\":1,\"cxxt\":\"测试库\"}]}}", idnum);
    }

    /**
     * description: 模拟正常接口返回值
     * author: linchunpeng
     * date:  2023-07-17 13:46
     */
    private String getMockNormal(String idnum) {
        return String.format("{\"msg\":\"请求成功\",\"code\":0,\"data\":{\"idNumber\":\"%s\",\"censorResult\":[]}}", idnum);
    }
}
