/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core;

import cn.hutool.core.collection.CollectionUtil;
import java.util.Collection;

public class AppConfigProperty {
    private final String rootPath;
    private final String domainUrl;
    private final Collection<String> proxiedTargets;
    private final String outRequsetDirKey;

    public AppConfigProperty(String rootPath, String domainUrl, Collection<String> proxiedTargets, String outRequsetDirKey) {
        this.rootPath = rootPath;
        this.domainUrl = domainUrl;
        this.proxiedTargets = proxiedTargets;
        this.outRequsetDirKey = outRequsetDirKey;
    }

    public static AppConfigProperty create(String rootPath, String domainUrl, Collection<String> proxiedTargets, String outRequsetDirKey) {
        return new AppConfigProperty(rootPath, domainUrl, proxiedTargets, outRequsetDirKey);
    }

    public boolean isSyncViaFtp(String targetApp) {
        if (CollectionUtil.isEmpty(this.proxiedTargets)) {
            return true;
        }
        return !this.proxiedTargets.contains(targetApp);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    public Collection<String> getProxiedTargets() {
        return this.proxiedTargets;
    }

    public String getOutRequsetDirKey() {
        return this.outRequsetDirKey;
    }
}

