/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.components;

import cn.hutool.http.HttpUtil;
import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.core.utils.JsonUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class IdentityChecker {
    private static final String JWT_SECRET = "xxx_test_secret";
    private static final int JWT_REFRESH_TTL = 3600000;

    public String getCheckResult(String url, String idNumber) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put("idNumber", IdentityChecker.createJwt(idNumber));
            String resultStr = HttpUtil.post((String)url, paramMap);
            return resultStr;
        }
        catch (Exception ex) {
            String msg = String.format("url=[%s]; param=[%s]; detail=[%s];", url, JsonUtil.getJson(paramMap), ExceptionUtils.getStackMessage(ex));
            throw new SaasBadException(msg, ex);
        }
    }

    private static String createJwt(String subject) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signatureAlgorithm, (Key)IdentityChecker.generalKey());
        long expMillis = System.currentTimeMillis() + 3600000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    private static String parseJwt(String token) {
        return ((Claims)Jwts.parser().setSigningKey((Key)IdentityChecker.generalKey()).parseClaimsJws(token).getBody()).getSubject();
    }

    private static SecretKey generalKey() {
        byte[] encodedKey = Base64.decodeBase64((String)JWT_SECRET);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }
}

