/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.components;

import com.bcxin.backend.core.models.CacheItemAbstract;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public interface CacheProvider {
    public <T> T getData(String var1, Supplier<T> var2);

    public void reset(String var1);

    public <T> void update(String var1, T var2);

    public static class CacheProviderImpl
    implements CacheProvider {
        private static ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap();

        @Override
        public <T> T getData(String key, Supplier<T> supplier) {
            assert (supplier != null);
            Object data = concurrentHashMap.get(key);
            if (data == null) {
                data = supplier.get();
                this.update(key, data);
            }
            if (data instanceof CacheItemAbstract && ((CacheItemAbstract)data).isExpired()) {
                data = supplier.get();
                this.update(key, data);
            }
            return (T)data;
        }

        @Override
        public void reset(String key) {
            concurrentHashMap.remove(key);
        }

        @Override
        public <T> void update(String key, T data) {
            if (data == null) {
                if (concurrentHashMap.contains(key)) {
                    concurrentHashMap.remove(key);
                }
                return;
            }
            concurrentHashMap.put(key, data);
        }
    }
}

