package com.bcxin.backend.core.edis;

import cn.hutool.core.date.DateUtil;

import java.util.Date;

public class EDIConstants {
    /**
     * 响应亮证的文件前缀
     */
    public static final String PUSH_CALLBACK_OUT_FILE_PREFIX = "OUT-JTLZ-";

    /**
     * 响应批量亮证的文件前缀
     */
    public static final String PUSH_BATCH_CALLBACK_OUT_FILE_PREFIX = "BATCH-OUT-JTLZ-";

    public static final String PUSH_FILE_EXTENSION = ".bcx";

    /**
     * 推送资格证文件签章
     */
    public static final String PUSH_IN_FILE_CERTIFICATE_PREFIX = "IN-JTLZ-01-";

    /**
     * 推送批量资格证文件签章
     */
    public static final String PUSH_BATCH_IN_FILE_CERTIFICATE_PREFIX = "BATCH-IN-JTLZ-01-";

    /**
     * 推送文书文件前缀
     */
    public static final String PUSH_IN_FILE_DOCUMENT_PREFIX = "IN-JTLZ-15-";

    /**
     * 推送批量文书文件前缀
     */
    public static final String PUSH_BATCH_IN_FILE_DOCUMENT_PREFIX = "BATCH-IN-JTLZ-15-";

    public static final String PUSH_IN_FILE_PREFIX="IN-JTLZ-";

    public static final String PUSH_IN_FZ_FILE_PREFIX="IN-JTLZFZ-";

    /**
     * 资格证元数据
     */
    public static final String PUSH_IN_FILE_PREFIX_META_ZGZ="INJTLZ-";
    /**
     * 资格证文书元数据
     */

    public static final String PUSH_IN_FILE_PREFIX_META_DOCUMENT="INJTLZDOCUMENT-";

    /**
     * 废止的文件格式
     */
    public static final String PUSH_IN_JTLZ_FZ_PREFIX_META="INJTLZFZ-";


    public static final String MESSAGE_DUPLICATE_CERTIFICATE_DOCUMENT = "重复的电子证照";


    /**
     * 亮证: 保安员证核发
     */
    public static final String CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SERVICE_CODE="1111000000002888XF200010910300001";
    public static final String CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SERVICE_NAME="保安员证核发";
    public static final String CODE_API_LIANG_ZHENG_LICENSE_CERTIFICATE_SEAL_CODE="DZYZ00002888XgNbYNa";

    /**
     * 亮证: 文书: 保安服务公司设立许可
     */
    public static final String CODE_API_LIANG_ZHENG_LICENSE_DOCUMENT_CERTIFICATE_SERVICE_CODE="1111000000002888XF200010910200101";
    public static final String CODE_API_LIANG_ZHENG_LICENSE_DOCUMENT_CERTIFICATE_SERVICE_NAME="保安服务公司设立许可";
    public static final String CODE_API_LIANG_ZHENG_LICENSE_DOCUMENT_CERTIFICATE_SEAL_CODE="DZYZ00002888XfxlBdz";

    /**
     * 亮证
     */
    public static final String PARAM_API_LIANG_ZHENG_SERVICE_ITEM_CODE="service_item_code";
    public static final String PARAM_API_LIANG_ZHENG_SERVICE_ITEM_NAME="service_item_name";

    public static final String PARAM_API_LIANG_ZHENG_BIZ_NUM="biz_num";

    public static final String PARAM_API_LIANG_ZHENG_OPERATOR="operator";

    public static final String PARAM_API_LIANG_ZHENG_ID_CODE="id_code";
    //保安资格证实施码
    private static String item_code_bazgz = "10001460100002888X110000";
    //保安许可证实施码
    private static String item_code_baxkz = "10001440100002888X110000";


    public static String getJTLZFileName(String id,String snowflakeId) {
        return EDIConstants.PUSH_IN_FILE_CERTIFICATE_PREFIX + item_code_bazgz + "-" + id + "N" + snowflakeId + PUSH_FILE_EXTENSION;
    }

    public static String getJTLZDocumentFileName(String id,String snowflakeId){
        return EDIConstants.PUSH_IN_FILE_DOCUMENT_PREFIX + item_code_baxkz + "-" + id + "N" + snowflakeId + PUSH_FILE_EXTENSION;
    }

    public static String getJTLZ_FZ_FileName(String id) {
        return "IN-JTLZFZ-01-" + item_code_bazgz + "-" + id + PUSH_FILE_EXTENSION;
    }

    public static String getJTLZDocument_FZ_FileName(String id){
        return "IN-JTLZFZ-15-" + item_code_baxkz + "-" + id + PUSH_FILE_EXTENSION;
    }

    public static String getFZSummaryFileName() {
        String minuteName = DateUtil.format(new Date(), "yyyyMMddHHmm");
        return PUSH_IN_JTLZ_FZ_PREFIX_META + minuteName + PUSH_FILE_EXTENSION;
    }

    public static String getSummaryFileName() {
        String minuteName = DateUtil.format(new Date(), "yyyyMMddHHmm");
        return PUSH_IN_FILE_PREFIX_META_ZGZ + minuteName + PUSH_FILE_EXTENSION;
    }

    public static String getDocumentSummaryFileName() {
        String minuteName = DateUtil.format(new Date(), "yyyyMMddHHmm");
        return PUSH_IN_FILE_PREFIX_META_DOCUMENT + minuteName + PUSH_FILE_EXTENSION;
    }

    public static boolean isPushError(String rt) {
        if (rt == null || rt.length() == 0) {
            return true;
        }
        if (rt.contains("FAILURE") && !rt.contains(EDIConstants.MESSAGE_DUPLICATE_CERTIFICATE_DOCUMENT)) {
            return true;
        }

        return false;
    }
}
