package com.bcxin.backend.core.components;

import cn.hutool.core.io.FileUtil;
import com.bcxin.backend.core.AppConfigProperty;

import java.io.File;

public interface StorageProvider {
    String save(String path, byte[] data);

    void rename(String path, String newName);

    byte[] read(String path);

    void remove(String path);

    String getDir();

    public static class StorageProviderImpl implements StorageProvider {
        private final AppConfigProperty appConfigProperty;

        public StorageProviderImpl(AppConfigProperty appConfigProperty) {
            this.appConfigProperty = appConfigProperty;
        }

        @Override
        public String save(String path, byte[] data) {
            String realPath = getRealPath(path);
            FileUtil.writeBytes(data, realPath);

            return realPath;
        }

        @Override
        public void rename(String path, String newName) {
            FileUtil.rename(new File(path), newName, false, true);
        }

        @Override
        public byte[] read(String path) {
            return FileUtil.readBytes(new File(getRealPath(path)));
        }

        @Override
        public void remove(String path) {
            FileUtil.del(getRealPath(path));
        }

        @Override
        public String getDir() {
            return appConfigProperty.getOutRequsetDirKey();
        }

        private String getRealPath(String path) {
            String finalPath = String.format("%s/%s", appConfigProperty.getRootPath(), path).replaceAll("//", "/");

            return finalPath;
        }
    }
}
