package com.bcxin.backend.core.components;

import lombok.Getter;

public interface CaptchaCodeProvider {
    CaptchaResult getBase64String();

    @Getter
    static class CaptchaResult {
        private final String Base64String;
        private final String code;

        private CaptchaResult(String base64String, String code) {
            Base64String = base64String;
            this.code = code;
        }

        public static CaptchaResult create(String base64String, String code) {
            return new CaptchaResult(base64String, code);
        }
    }
}
