/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.core.components;

import cn.hutool.core.io.FileUtil;
import com.bcxin.backend.core.AppConfigProperty;
import java.io.File;

public interface StorageProvider {
    public String save(String var1, byte[] var2);

    public void rename(String var1, String var2);

    public byte[] read(String var1);

    public void remove(String var1);

    public String getDir();

    public static class StorageProviderImpl
    implements StorageProvider {
        private final AppConfigProperty appConfigProperty;

        public StorageProviderImpl(AppConfigProperty appConfigProperty) {
            this.appConfigProperty = appConfigProperty;
        }

        @Override
        public String save(String path, byte[] data) {
            String realPath = this.getRealPath(path);
            FileUtil.writeBytes((byte[])data, (String)realPath);
            return realPath;
        }

        @Override
        public void rename(String path, String newName) {
            FileUtil.rename((File)new File(path), (String)newName, (boolean)false, (boolean)true);
        }

        @Override
        public byte[] read(String path) {
            return FileUtil.readBytes((File)new File(this.getRealPath(path)));
        }

        @Override
        public void remove(String path) {
            FileUtil.del((String)this.getRealPath(path));
        }

        @Override
        public String getDir() {
            return this.appConfigProperty.getOutRequsetDirKey();
        }

        private String getRealPath(String path) {
            String finalPath = String.format("%s/%s", this.appConfigProperty.getRootPath(), path).replaceAll("//", "/");
            return finalPath;
        }
    }
}

