package com.bcxin.backend.strategy.bg.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bcxin.backend.dto.bg.BgScreeningParams;
import com.bcxin.backend.dto.bg.BgScreeningResultDto;
import com.bcxin.backend.strategy.bg.BgScreeningStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * description: 湖南背筛比对策略
 * author: linchunpeng
 * date:  2023-07-14 9:59
 */
@Slf4j
@Service
public class HunanBgScreeningCompare extends BaseBgScreeningCompare implements BgScreeningStrategy {

    /**
     * description: 执行背筛比对
     * author: linchunpeng
     * date:  2023-07-14 10:00
     */
    @Override
    public List<BgScreeningResultDto> executeBgScreening(BgScreeningParams params) {
        List<BgScreeningResultDto> resultDtoList = new ArrayList<>();
        for (String idnum : params.getBgUserIdnumList()) {
            //循环背筛身份证列表，单个进行背筛
            HttpResponse execute = HttpUtil.createGet(params.getApi().concat(idnum)).execute();
            //接口返回值
            String apiResult = execute.body();
            log.info("身份证号：{}，调用背筛接口，状态：{}，返回值：{}", idnum, execute.getStatus(), apiResult);
            if (execute.isOk()) {
                //请求成功
                log.info("身份证号：{}，调用背筛接口成功", idnum);
                BgScreeningResultDto resultDto = super.getResultDtoByApiResult(apiResult);
                resultDto.setIdnum(idnum);
                if (resultDto.getIsProblem() != null) {
                    resultDtoList.add(resultDto);
                }
            } else {
                log.info("身份证号：{}，调用背筛接口失败", idnum);
            }
        }
        return resultDtoList;
    }

}
