package com.bcxin.backend.strategy.bg.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.dto.bg.BgScreeningApiResultDto;
import com.bcxin.backend.dto.bg.BgScreeningResultDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * description: 背筛比对基础类
 * author: linchunpeng
 * date:  2023-07-14 9:59
 */
@Slf4j
public class BaseBgScreeningCompare {

    /**
     * description: 解析背筛比对结果
     * author: linchunpeng
     * date:  2023-07-14 10:00
     */
    public BgScreeningResultDto getResultDtoByApiResult(String result) {
        BgScreeningResultDto resultDto = new BgScreeningResultDto();
        resultDto.setApiResult(result);
        BgScreeningApiResultDto apiResultDto = JSONObject.parseObject(result, BgScreeningApiResultDto.class);
        if (apiResultDto.getCode() == 500) {
            log.info("认证接口异常，返回500");
        } else {
            if (apiResultDto.getData() != null) {
                //data不为空
                if (CollectionUtil.isNotEmpty(apiResultDto.getData().getCensorResult())) {
                    //审查结果不为空，是问题人员
                    List<String> problemDetailList = new ArrayList<>();
                    //取出问题列表
                    for (BgScreeningApiResultDto.ApiResultDataCensorResultDto censorResultDto : apiResultDto.getData().getCensorResult()) {
                        if (censorResultDto.getData() != null && StringUtils.isNotBlank(censorResultDto.getData().getDetail())) {
                            problemDetailList.add(censorResultDto.getData().getDetail());
                        }
                    }
                    resultDto.setIsProblem(true);
                    resultDto.setProblemDetailList(problemDetailList);
                } else {
                    //不是问题人员
                    resultDto.setIsProblem(false);
                }
            } else {
                //不是问题人员
                resultDto.setIsProblem(false);
            }
        }
        return resultDto;
    }

}
