package com.bcxin.backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.backend.dao.mapper.EmployeesMapper;
import com.bcxin.backend.entity.Employees;
import com.bcxin.backend.service.EmployeesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description: 背筛用户表service
 * author: linchunpeng
 * date:  2023-07-13 14:30
 */
@Slf4j
@Service
public class EmployeesServiceImpl extends ServiceImpl<EmployeesMapper, Employees> implements EmployeesService {

    /**
     * description：根据身份证列表吗，查询在职公司与入职时间
     * author：linchunpeng
     * date：2023/7/18
     */
    @Override
    public List<Employees> findByItemDocumentIdList(List<String> itemDocumentIdList) {
        QueryWrapper<Employees> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id_no", itemDocumentIdList);//身份证列表
        queryWrapper.eq("employed", 0);//在职状态：0
        return this.list(queryWrapper);
    }

}
