package com.bcxin.backend.dto.bg;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.backend.common.BgConstant;
import com.bcxin.backend.entity.BgScreeningUserExecLog;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * description: 背筛比对结果对象dto
 * author: linchunpeng
 * date:  2023-07-14 9:39
 */
@Data
public class BgScreeningResultDto {

    /**
     * 身份证
     */
    private String idnum;

    /**
     * 是否问题人员
     */
    private Boolean isProblem;

    /**
     * 问题明细列表
     */
    private List<String> problemDetailList;

    /**
     * api接口返回完整记录
     */
    private String apiResult;

    /**
     * description：获取背筛状态
     * author：linchunpeng
     * date：2023/7/18
     */
    public Integer getBgStatus() {
        if (this.isProblem) {
            //是问题人员，背筛状态为1
            return 1;
        }
        //否则背筛状态为0
        return 0;
    }

    /**
     * description：获取问题明细
     * author：linchunpeng
     * date：2023/7/18
     */
    public String getProblemDetail() {
        if (CollectionUtil.isNotEmpty(this.problemDetailList)) {
            return String.join(",", this.problemDetailList);
        }
        return "";
    }

    /**
     * description：获取问题类型
     * author：linchunpeng
     * date：2023/7/18
     */
    public Set<Integer> getQuestionType() {
        //1在逃,2吸毒，3重点
        Set<Integer> result = new HashSet<>();
        if (this.isProblem && CollectionUtil.isNotEmpty(this.problemDetailList)) {
            List<String> zdList = new ArrayList<>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_1)
                        || StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_2)) {
                    result.add(2);
                } else if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_ZT_STR)) {
                    result.add(1);
                } else {
                    zdList.add(detail);
                }
            }
            if (CollectionUtil.isEmpty(result) || CollectionUtil.isNotEmpty(zdList)) {
                //如果都不是吸毒或者在逃 || 在逃列表不以为空，那就是重点人员
                result.add(3);
            }
        }
        return result;
    }

    /**
     * description：最近一次背筛结果状态（0正常 1在逃，2吸毒，3重点，4精神，位移计算）
     * author：linchunpeng
     * date：2023/7/18
     */
    public int getBgResultType() {
        int result = 0;
        if (this.isProblem && CollectionUtil.isNotEmpty(this.problemDetailList)) {
            List<String> zdList = new ArrayList<>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_1)
                        || StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_2)) {
                    result += Math.pow(2, 1);
                } else if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_ZT_STR)) {
                    result += Math.pow(2, 0);
                } else if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_JSB_STR)) {
                    result += Math.pow(2, 3);
                } else {
                    zdList.add(detail);
                }
            }
            if (result == 0 || CollectionUtil.isNotEmpty(zdList)) {
                //如果都不是吸毒或者在逃 || 在逃列表不以为空，那就是重点人员
                result += Math.pow(2, 2);
            }
        }
        return result;
    }

    /**
     * description：最近一次背筛结果状态（0正常 1在逃，2吸毒，3重点，4精神，位移计算）
     * author：linchunpeng
     * date：2023/7/18
     */
    public String getBgResult() {
        StringBuffer result = new StringBuffer();
        if (this.isProblem && CollectionUtil.isNotEmpty(this.problemDetailList)) {
            List<String> zdList = new ArrayList<>();
            for (String detail : this.problemDetailList) {
                if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_1)
                        || StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_XD_STR_2)) {
                    result.append("吸毒，");
                } else if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_ZT_STR)) {
                    result.append("在逃，");
                } else if (StringUtils.contains(detail, BgConstant.BG_QUESTION_TYPE_JSB_STR)) {
                    result.append("精神病，");
                } else {
                    zdList.add(detail);
                }
            }
            if (result.toString().equals("") || CollectionUtil.isNotEmpty(zdList)) {
                //如果都不是吸毒或者在逃 || 在逃列表不以为空，那就是重点人员
                result.append("重点，");
            }
        }
        return result.toString();
    }

    public BgScreeningUserExecLog getBgScreeningUserExecLog(Date now, Long bgUserId) {
        BgScreeningUserExecLog log = new BgScreeningUserExecLog();
        log.setType(2);
        log.setCreatedTime(now);
        log.setIdnum(this.idnum);
        log.setShortResult(this.getProblemDetail());
        log.setResult(this.apiResult);
        log.setQuestionType(this.getBgResultType());
        log.setBgUserId(bgUserId);
        return log;
    }


}
