/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.models;

import com.bcxin.backend.domain.models.SuperviseDTO;

public class DomainSuperviseDTO {
    private String domainId;
    private SuperviseDTO supervise;

    public String getIdentityValue() {
        return String.format("domainId=%s;systemURLNw=%s;systemUrl=%s;systemAdmin=%s;targetServiceUrl=%s", this.domainId, this.supervise.getTargetApp(), this.supervise.getSrcApp(), this.supervise.getSystemAdmin(), this.supervise.getTargetServiceUrl());
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().isAssignableFrom(DomainSuperviseDTO.class)) {
            return false;
        }
        DomainSuperviseDTO o = (DomainSuperviseDTO)obj;
        int result = this.getDomainId().compareTo(o.getDomainId());
        if (result != 0) {
            return false;
        }
        return this.getIdentityValue().compareTo(o.getIdentityValue()) == 0;
    }

    public static DomainSuperviseDTO create(String domainId, SuperviseDTO supervise) {
        DomainSuperviseDTO domainSupervise = new DomainSuperviseDTO();
        domainSupervise.setDomainId(domainId);
        domainSupervise.setSupervise(supervise);
        return domainSupervise;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public SuperviseDTO getSupervise() {
        return this.supervise;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void setSupervise(SuperviseDTO supervise) {
        this.supervise = supervise;
    }

    public String toString() {
        return "DomainSuperviseDTO(domainId=" + this.getDomainId() + ", supervise=" + this.getSupervise() + ")";
    }
}

