package com.bcxin.signature.util.ftp;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

/**
 * <b> 上传任务 </b>
 * @author ZXF
 * @create 2023/07/07 0007 13:44
 * @version
 * @注意事项 </b>
 */
public class DownloadTask implements Callable {
    private FtpConnection ftp;

    private String path;

    private String fileName;

    private FtpFactory factory;

    public DownloadTask(FtpFactory factory, FtpConnection ftp, String path, String fileName){

        this.factory = factory;

        this.ftp = ftp;

        this.path = path;

        this.fileName = fileName;

    }

    @Override
    public DownloadResult call() throws Exception {
        DownloadResult result = null;
        try {
            ftp = new FtpConnection();

            //开始上传
            result = new DownloadResult(fileName, ftp.getFileContent(path, fileName));
        } catch (IOException ex) {
            result = new DownloadResult(fileName, "");
            ex.printStackTrace();
        } finally {
            try {
                ftp.delectFile(path,fileName);
                if(factory != null){
                    factory.relase(ftp);//释放连接
                }
            }catch (Exception e){
                System.out.println("===ERR===>  ftp download delete file fail,fileName:"+fileName);
            }
        }
        return result;

    }
}
