package com.bcxin.signature.components;

import com.bcxin.backend.core.edis.EDIConstants;

/**
 * 资格证文书推送
 */
public interface DocumentPushProvider {
    void push(DocumentType documentType);

    /**
     * 推送废止的数据
     */
    void cancel_push();


    public static enum DocumentType {
        /**
         * 文书
         */
        Document{
            @Override
            public String getPrefix() {
                return EDIConstants.PUSH_IN_FILE_PREFIX;
            }

            @Override
            public String getMetaPrefix() {
                return EDIConstants.PUSH_IN_FILE_PREFIX_META_ZGZ;
            }

            @Override
            public String getLabel() {
                return "Document";
            }
        },
        /**
         * 资格证
         */
        Certificate{
            @Override
            public String getPrefix() {
                return EDIConstants.PUSH_IN_FILE_DOCUMENT_PREFIX;
            }

            @Override
            public String getMetaPrefix() {
                return EDIConstants.PUSH_IN_FILE_PREFIX_META_DOCUMENT;
            }

            @Override
            public String getLabel() {
                return "Certificate";
            }
        },
        ;

         public abstract String getPrefix();

        public abstract String getMetaPrefix();

        public abstract String getLabel();
    }
}
