package com.bcxin.oa.old.service.task.app;

import com.bcxin.oa.old.entity.task.ComTaskSchedul;
import com.bcxin.oa.old.dto.ComTaskAdjustApproveDto;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.app.AppComTaskDTO;
import com.bcxin.oa.old.dto.app.AppComTaskImplementDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

/**
 * APP任务列表
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
public interface AppComTaskService {

    /**
     * 获取APP任务列表
     *
     * @param appComTaskDTO
     * @return
     */
    Result pageTask(AppComTaskDTO appComTaskDTO) throws BusinessException;


    /**
     * 获取个人APP任务列表
     *
     * @param dto
     * @author llc
     * @date 2020-04-10
     * @return
     */
    Result getPerTaskList(ComTaskDto dto) throws BusinessException;

    /**
     * 获取APP任务详情
     *
     * @param appComTaskDTO
     * @return
     */
    Result getTaskDetails(AppComTaskDTO appComTaskDTO) throws BusinessException;

    /**
     * 获取APP用户正在执行任务
     *
     * @param appComTaskDTO
     * @return
     */
    Result getRuningTaskRound(AppComTaskDTO appComTaskDTO) throws BusinessException;

    /**
     * 获取任务成员列表
     *
     * @param appComTaskDTO
     * @return
     */
    Result getTaskPerson(AppComTaskDTO appComTaskDTO) throws BusinessException;

    /**
     * 班次执行情况查询
     *
     * @param appComTaskImplementDto
     * @return
     */
    Result getTaskShiftImplement(AppComTaskImplementDto appComTaskImplementDto) throws BusinessException;

    /**
     * 获取APP任务状态
     *
     * @param appComTaskDTOParam
     * @return
     */
    Result getTaskStatus(AppComTaskDTO appComTaskDTOParam) throws BusinessException;


    /**
     * 获取某人某天某任务的排班班次
     *
     * @param comTaskSchedul
     * @return
     * @author llc
     * @date 2019-02-21
     */
    Result getPerDateTaskShift(ComTaskSchedul comTaskSchedul) throws BusinessException;


    /**
     * 外勤代班审批通过业务实现
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-02-21
     */
     Result completeTaskAdjustApprove(ComTaskAdjustApproveDto dto) throws BusinessException;


    /**
     * 查询个人的外勤详情
     * （基于getTaskDetails方法整改）
     * @param appComTaskDTO
     * * @author llc
     * @date 2019-02-25
     * @return
     * @throws BusinessException
     */
    Result getTaskDetailsByPerId(AppComTaskDTO appComTaskDTO) throws BusinessException;

}