package com.bcxin.oa.old.service.task;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSplitter;
import cn.hutool.core.util.StrUtil;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.dto.MultiDataDTO;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.ShiftConflictResultDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.service.task.bbd.BbdTestService;
import com.bcxin.oa.old.common.*;
import com.bcxin.oa.old.common.CommonConst;
import com.bcxin.oa.old.common.DictConst;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * 人员排班的逻辑
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/9
 */
@Service
@Transactional
public class ComTaskPerShiftServiceImpl implements ComTaskPerShiftService {

    private final static String[] SHIFT_ALIAS_ARRAY = {"班次A", "班次B", "班次C", "班次D", "班次E", "班次F", "班次G", "班次H", "班次I",
            "班次J", "班次K", "班次L", "班次M", "班次N", "班次O", "班次P", "班次Q", "班次R", "班次S", "班次T", "班次U", "班次V", "班次W", "班次X",
            "班次Y", "班次Z", "休"};

    private final static String[] SHIFT_ALIAS_ALPHA_ARRAY = {"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K",
            "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "XX"};

    private final static String REST_SHIFT_ALIAS = "休：休息";

    private final static String REST_EN = "休";

    private final static String CYCLE_SHIFT_NAME = "班次轮换：";

    /**
     * 班次排班
     */
    private final static String TASKSHIFTTYPE_BC = "1";

    /**
     * 周期排班
     */
    private final static String TASKSHIFTTYPE_ZQ = "2";

    @Resource
    private ComTaskShiftMapper comTaskShiftMapper;

    @Resource
    private ComTaskMapper comTaskMapper;

    @Resource
    private ComShiftRuleMapper comShiftRuleMapper;

    @Resource
    private ComTaskSchedulCycleMapper comTaskSchedulCycleMapper;

    @Resource
    private ComTaskCycleShiftMapper comTaskCycleShiftMapper;

    @Resource
    private ComTaskImplementMapper comTaskImplementMapper;

    @Resource
    private ComTaskSchedulMapper comTaskSchedulMapper;

    @Resource
    private CommonService commonService;

    @Resource
    private ValidateTaskFixedMapper validateTaskFixedMapper;

    @Resource
    private BbdTestService bbdTestService;

    @Resource
    private IdWorker idWorker;
    /**
     * 根据任务获得选择的班次/排班周期
     *
     * @param paramDTO
     * @return
     * @throws BusinessException
     * @update zhangjianhua
     */
    @Override
    public Result getShiftByTask(ParamDTO paramDTO) throws BusinessException {
        Map<String, Object> resultMap = Maps.newHashMap();

        // 1、参数校验
        ComTask comTask = checkTask(paramDTO.getComTaskId());

        // 2、判断任务类型，以获取班次
        String attendType = comTask.getAttendType();

        // 固定班制，无排班周期
        if (DictConst.ATTENDTYPE_GDBZ.equals(attendType)) {
            getShiftDetail(paramDTO, resultMap, attendType);
        }
        // 排班制，有排班周期
        else if (DictConst.ATTENDTYPE_PBZ.equals(attendType)) {
            getShiftDetail(paramDTO, resultMap, attendType);
            getShiftSchedule(paramDTO, resultMap);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 获得排班，班次信息
     *
     * @param paramDTO
     * @param result
     * @update zhangjianhua
     */
    private void getShiftDetail(ParamDTO paramDTO, Map<String, Object> result, String attendType) {
        /* 班次的字母别名 如： A */
        Map<Long, String> shiftAliasAlphaMap = Maps.newHashMap();

        List<MultiDataDTO> shiftList = new ArrayList<>();

        // 1、排班制获取班次
        if (DictConst.ATTENDTYPE_PBZ.equals(attendType)) {
            shiftList = comTaskShiftMapper.getShiftByTask(paramDTO.getComTaskId());
            // 固定班制获取班次
        } else if (DictConst.ATTENDTYPE_GDBZ.equals(attendType)) {
            shiftList = comTaskShiftMapper.getShiftByFixedTask(paramDTO.getComTaskId());
        }
        int index = 0;
        /* 设置班次的别名 如 班次A：9：00~10：00 班次B：9：00~10：00 */
        if (shiftList != null && shiftList.size() > 0) {
            for (MultiDataDTO dataMap : shiftList) {
                String workTimeStr = commonService.listChangeToString(dataMap.getShiftId(), false, false);
                dataMap.setShiftAlias(SHIFT_ALIAS_ARRAY[index] + CommonConst.COLON_CN + workTimeStr);
                shiftAliasAlphaMap.put(dataMap.getShiftId(), SHIFT_ALIAS_ALPHA_ARRAY[index]);
                index++;
            }
        }

        /* 设置休息的班次 */
        MultiDataDTO dataDTO = new MultiDataDTO();
        dataDTO.setShiftId(0L);
        dataDTO.setShiftAlias(REST_SHIFT_ALIAS);
        shiftList.add(dataDTO);

        shiftAliasAlphaMap.put(0L, REST_EN);

        result.put("shiftAliasAlphaMap", shiftAliasAlphaMap);
        result.put("shiftList", shiftList);
    }

    /**
     * 获得排班周期
     *
     * @param paramDTO
     * @param result
     */
    private void getShiftSchedule(ParamDTO paramDTO, Map<String, Object> result) {
        Map<Long, String> shiftAliasAlphaMap = (Map<Long, String>) result.get("shiftAliasAlphaMap");
        Map<Long, Map<String, String>> allCycleDetailMap = Maps.newHashMap();
        // 1、获取排班周期
        List<Map> cycleList = comTaskSchedulCycleMapper.getTaskCycle(paramDTO.getComTaskId());
        for (Map map : cycleList) {
            Object cycleIdObj = map.get("taskSchedulCycleId");
            Object cycleNameObj = map.get("cycleName");
            Object cycleDaysObj = map.get("cycleDays");
            map.put("cycleAlias", cycleNameObj.toString() + CommonConst.COLON_CN + cycleDaysObj + "天");

            Map<String, String> cycleDetailMap = Maps.newHashMap();

            // 2、获取周期明细
            StringBuilder cycleShiftName = new StringBuilder(CYCLE_SHIFT_NAME);
            List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper
                    .getTaskCycleShift(Long.parseLong(cycleIdObj.toString()));
            int loop = 0;
            for (MultiDataDTO dataDTO : cycleShiftList) {
                if (loop > 0) {
                    cycleShiftName.append(CommonConst.MINUS);
                }
                /* 休息日 */
                if (CommonConst.Y.equals(dataDTO.getIsRest())) {
                    cycleShiftName.append(REST_EN);
                    cycleDetailMap.put(dataDTO.getWhatDay(), "0");
                } else {
                    String shiftAliasAlpha = shiftAliasAlphaMap.get(dataDTO.getShiftId());
                    if (StrUtil.isNotEmpty(shiftAliasAlpha)) {
                        cycleShiftName.append(shiftAliasAlpha);
                    }

                    String value = cycleDetailMap.get(dataDTO.getWhatDay());
                    if (StrUtil.isEmpty(value)) {
                        cycleDetailMap.put(dataDTO.getWhatDay(), dataDTO.getShiftId() + "");
                    } else {
                        cycleDetailMap.put(dataDTO.getWhatDay(), value + CommonConst.COMMA + dataDTO.getShiftId());
                    }
                }
                loop++;
            }
            map.put("cycleShiftName", cycleShiftName);

            allCycleDetailMap.put(Long.parseLong(cycleIdObj.toString()), cycleDetailMap);
        }

        result.put("cycleList", cycleList);
        result.put("allCycleDetailMap", allCycleDetailMap);
    }



    /**
     * 根据任务获得人员设置的考勤（搜索框），查看状态模式
     *
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    @Override
    public Result pagePerShift(ParamDTO paramDTO) throws BusinessException {
        if (StrUtil.isEmpty(paramDTO.getMonth())) {
            throw new BusinessException(Result.ERROR, "请选择月份");
        }
        Long taskId = paramDTO.getComTaskId();
        ComTask comTask = checkTask(taskId);

        // 获得任务关联的参与人员
        // perid perName
        PageHelper.startPage(paramDTO.getPageNumber(), paramDTO.getPageSize());

        List<Map<String,String>> perMapList = comTaskShiftMapper.getTaskPerListByTaskId(comTask.getComTaskId());

        Map<String, Object> resultMap = Maps.newHashMap();

        Date startDate = DateUtil.parse(paramDTO.getMonth() + "-01");

        Date endDate = DateUtil.endOfMonth(startDate);

        List<MultiDataDTO> perList = new ArrayList<>();

        for(Map<String,String> map : perMapList){
            MultiDataDTO dto = new MultiDataDTO();
            dto.setPerId(Long.parseLong(map.get("perId")));
            dto.setPerName(map.get("perName"));
            dto.setIsActive(map.get("isActive"));
            perList.add(dto);
        }

        Map<Long, Map<String, String>> perShiftAllMap = Maps.newLinkedHashMap();
        Multimap<Long, MultiDataDTO> perShiftMap = ArrayListMultimap.create();

        /* 搜索的人员为空 */
        if (CollectionUtil.isEmpty(perList)) {
//            resultMap.put("perList", new PageInfoUtils(perMapList));
            resultMap.put("perShiftAllMap", perShiftAllMap.values());
            return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
        }

        // 获得筛选人员当月的排班
        List<MultiDataDTO> perShiftAllList = comTaskShiftMapper.getPerShiftByPerList(taskId, paramDTO.getComId(),
                perList,
                DateUtils.formatDate(startDate),
                DateUtils.formatDate(endDate));

        /* 当月的日期集合 */
        List<String> dateList = DateUtils.getDatesByMonth(paramDTO.getMonth());

        /* 循环每一个人员，然后每一天一个Map，key为日期，value为班次id1,班次id2 */
        perShiftAllList.forEach(one -> {
            /* 一个人员的 每天的排班集合 */
            perShiftMap.put(one.getPerId(), one);
        });

        for (MultiDataDTO per : perList) {
            getPerShiftByMonth(perShiftAllMap, perShiftMap, dateList, per);
        }
        resultMap.put("perList", new PageInfoUtils(perMapList));
        resultMap.put("perShiftAllMap", perShiftAllMap.values());
        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }


    /**
     * 重载pagePerShift方法。用于导出班次,不分页
     *
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    @Override
    public Result pagePerShiftExport(ParamDTO paramDTO) throws BusinessException {
        Map<String, Object> resultMap = Maps.newHashMap();
        // 1、参数校验
        Long taskId = paramDTO.getComTaskId();
        ComTask comTask = checkTask(taskId);

        if (StrUtil.isEmpty(paramDTO.getMonth())) {
            throw new BusinessException(Result.ERROR, "请选择月份");
        }

        Date startDate = DateUtil.parse(paramDTO.getMonth() + "-01");

        Date endDate = DateUtil.endOfMonth(startDate);

        // 获得任务关联的参与人员
        // perid perName
        List<MultiDataDTO> perList = comTaskShiftMapper.getCurrentPerByTaskExport(comTask.getComTaskId(), paramDTO.getComId());

        Map<Long, Map<String, String>> perShiftAllMap = Maps.newLinkedHashMap();
        Multimap<Long, MultiDataDTO> perShiftMap = ArrayListMultimap.create();

        /* 搜索的人员为空 */
        if (CollectionUtil.isEmpty(perList)) {
            resultMap.put("perList", perList);
            resultMap.put("perShiftAllMap", perShiftAllMap.values());
            return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
        }

        // 获得筛选人员当月的排班
        List<MultiDataDTO> perShiftAllList = comTaskShiftMapper.getPerShiftByPerList(taskId, paramDTO.getComId(),
                perList,
                DateUtils.formatDate(startDate),
                DateUtils.formatDate(endDate));

        /* 当月的日期集合 */
        List<String> dateList = DateUtils.getDatesByMonth(paramDTO.getMonth());

        /* 循环每一个人员，然后每一天一个Map，key为日期，value为班次id1,班次id2 */
        perShiftAllList.forEach(one -> {
            /* 一个人员的 每天的排班集合 */
            perShiftMap.put(one.getPerId(), one);
        });

        for (MultiDataDTO per : perList) {
            getPerShiftByMonth2(perShiftAllMap, perShiftMap, dateList, per);
        }

        resultMap.put("perShiftAllMap", perShiftAllMap.values());
        resultMap.put("comTask",comTask);

        return Result.success(Result.SUCCESS_QUERY_MSG, resultMap);
    }

    /**
     * 获得一个人一个月的考勤数据
     *
     * @param perShiftAllMap
     * @param perShiftMap
     * @param dateList
     * @param per
     */
    private void getPerShiftByMonth(Map<Long, Map<String, String>> perShiftAllMap,
                                    Multimap<Long, MultiDataDTO> perShiftMap, List<String> dateList, MultiDataDTO per) {
        Collection<MultiDataDTO> dataCollection = perShiftMap.get(per.getPerId());
        // 如果没有任何的设置，则将每天设置为空值
        if (CollectionUtil.isEmpty(dataCollection)) {
            // 循环当月的每天，给一个人员每天设置一个值
            Map<String, String> perSingleMap = Maps.newLinkedHashMap();
            perSingleMap.put("perId", per.getPerId() + "");
            perSingleMap.put("name", per.getPerName());
            perSingleMap.put("isActive",per.getIsActive());
            for (String date : dateList) {
                perSingleMap.put(date, "");
            }
            perShiftAllMap.put(per.getPerId(), perSingleMap);
            return;
        }

        // 循环当月的每天，给一个人员每天设置一个值
        Map<String, String> perSingleMap = Maps.newLinkedHashMap();
        perSingleMap.put("perId", per.getPerId() + "");
        perSingleMap.put("name", per.getPerName());
        perSingleMap.put("isActive",per.getIsActive());
        for (String date : dateList) {
            boolean hasRecord = false;
            for (MultiDataDTO data : dataCollection) {
                /* 日期相等，当天有数据 */
                if (Objects.equals(date, data.getDates())) {
                    hasRecord = true;
                    /* 当天有设置数据 */
                    if (perSingleMap.containsKey(date)) {
                        /* 如果班次为null，说明当天设置的是休息 */
                        if (data.getShiftId() == null) {
                            perSingleMap.put(date, "0");
                            continue;
                        }
                        /* 拿到原来的值 */
                        String value = String.valueOf(perSingleMap.get(date));
                        /* 如果里面没有这个班次，说明不需要添加进来 */
                        if (!value.contains(String.valueOf(data.getShiftId()))) {
                            perSingleMap.put(date, value + PublicConst.DOT + data.getShiftId());
                        }
                    }
                    /* 当天暂时还没有数据 */
                    else {
                        /* 如果班次为null，说明当天设置的是休息 */
                        if (data.getShiftId() == null) {
                            perSingleMap.put(date, "0");
                        } else {
                            perSingleMap.put(date, data.getShiftId() + "");
                        }
                    }
                }
            }
            if (!hasRecord) {
                /* 当天没有数据 */
                perSingleMap.put(date, "");
            }
        }
        perShiftAllMap.put(per.getPerId(), perSingleMap);
    }

    /**
     * 获得一个人一个月的考勤数据,重载此方法,增加身份证等数值
     *
     * @param perShiftAllMap
     * @param perShiftMap
     * @param dateList
     * @param per
     */
    private void getPerShiftByMonth2(Map<Long, Map<String, String>> perShiftAllMap,
                                     Multimap<Long, MultiDataDTO> perShiftMap, List<String> dateList, MultiDataDTO per) {
        Collection<MultiDataDTO> dataCollection = perShiftMap.get(per.getPerId());
        // 如果没有任何的设置，则将每天设置为空值
        if (CollectionUtil.isEmpty(dataCollection)) {
            // 循环当月的每天，给一个人员每天设置一个值
            Map<String, String> perSingleMap = Maps.newLinkedHashMap();
            perSingleMap.put("perId", per.getPerId() + "");
            perSingleMap.put("name", per.getPerName());
            perSingleMap.put("departName", per.getDepartName());
            perSingleMap.put("idCardNo", per.getIdCardNo());
            perSingleMap.put("mobilePhone", per.getMobilePhone());
            for (String date : dateList) {
                perSingleMap.put(date, "");
            }
            perShiftAllMap.put(per.getPerId(), perSingleMap);
            return;
        }

        // 循环当月的每天，给一个人员每天设置一个值
        Map<String, String> perSingleMap = Maps.newLinkedHashMap();
        perSingleMap.put("perId", per.getPerId() + "");
        perSingleMap.put("name", per.getPerName());
        perSingleMap.put("departName", per.getDepartName());
        perSingleMap.put("idCardNo", per.getIdCardNo());
        perSingleMap.put("mobilePhone", per.getMobilePhone());

        for (String date : dateList) {
            boolean hasRecord = false;
            for (MultiDataDTO data : dataCollection) {
                /* 日期相等，当天有数据 */
                if (Objects.equals(date, data.getDates())) {
                    hasRecord = true;
                    /* 当天有设置数据 */
                    if (perSingleMap.containsKey(date)) {
                        /* 如果班次为null，说明当天设置的是休息 */
                        if (data.getShiftId() == null) {
                            perSingleMap.put(date, "0");
                            continue;
                        }
                        /* 拿到原来的值 */
                        String value = String.valueOf(perSingleMap.get(date));
                        /* 如果里面没有这个班次，说明不需要添加进来 */
                        if (!value.contains(String.valueOf(data.getShiftId()))) {
                            perSingleMap.put(date, value + PublicConst.DOT + data.getShiftId());
                        }
                    }
                    /* 当天暂时还没有数据 */
                    else {
                        /* 如果班次为null，说明当天设置的是休息 */
                        if (data.getShiftId() == null) {
                            perSingleMap.put(date, "0");
                        } else {
                            perSingleMap.put(date, data.getShiftId() + "");
                        }
                    }
                }
            }
            if (!hasRecord) {
                /* 当天没有数据 */
                perSingleMap.put(date, "");
            }
        }
        perShiftAllMap.put(per.getPerId(), perSingleMap);
    }

    @Override
    public Result validateSchedulCycle(ParamDTO paramDTO) throws BusinessException {
        // 1、参数校验
        if (StrUtil.isEmpty(paramDTO.getIds())) {
            throw new BusinessException(Result.ERROR, "班次id不能为空");
        }
        /* 校验当前排班是否有重复区间 */
        List<String> idList = StrSplitter.split(paramDTO.getIds(), CommonConst.COMMA, true, true);
        if (CollectionUtil.isEmpty(idList)) {
            throw new BusinessException(Result.ERROR, "班次id不能为空");
        }
        /* 需要第一天比对第二天，第二天和第三天比对，直到结束 */
        Map<String, List<ComShiftRule>> ruleMap = Maps.newHashMap();
        List<MultiDataDTO> planShiftListMap = Lists.newArrayList();
        int shiftCount = idList.size();
        for (String shiftId : idList) {
            List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftId(Long.parseLong(shiftId));
            ruleMap.put(shiftId, shiftRuleList);
        }

        for (int i = 0; i < idList.size(); i++) {
            /* 如果是第一天，需要拿第二天 */
            if (i == 0) {
                convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(i)), false, true);
                if (shiftCount > (i + 1)) {
                    convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(i + 1)), false, false);
                }
            }
            /* 如果是最后一天，拿前一天和拿第一天 */
            else if (shiftCount == (i + 1)) {
                convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(i)), false, true);
                int yesterday = i - 1;
                int firstDay = 0;
                /* 前一天和第一天是同一天，只需要累加一天 */
                if (yesterday == firstDay) {
                    convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(yesterday)), false, true);
                } else {
                    /* 昨天 */
                    convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(yesterday)), true, false);
                    List<String> planShiftList = timeNodeClassConvert(planShiftListMap);
                    ShiftConflictResultDTO conflictDTO = checkOverlap(planShiftList, "");
                    if (!conflictDTO.getIsCorrect()) {
                        conflictDTO.setErrorMsg("当前选择的班次有时间冲突，冲突时间段为[" + conflictDTO.getPeriod() + "]");
                        return Result.fail(conflictDTO.getErrorMsg());
                    }
                    /* 校验完之后清除掉 */
                    planShiftListMap.clear();

                    /* 再拿今天，校验第一天 */
                    convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(i)), false, true);
                    convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(firstDay)), false, false);
                }
            }
            /* 中间的天数，拿前一天 */
            else {
                convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(i)), false, false);
                int yesterday = i - 1;
                /* 前一天 */
                convertToTimeNode(planShiftListMap, ruleMap.get(idList.get(yesterday)), true, false);
            }

            List<String> planShiftList = timeNodeClassConvert(planShiftListMap);
            ShiftConflictResultDTO conflictDTO = checkOverlap(planShiftList, "");
            if (!conflictDTO.getIsCorrect()) {
                conflictDTO.setErrorMsg("当前选择的班次有时间冲突，冲突时间段为[" + conflictDTO.getPeriod() + "]");
                return Result.fail(conflictDTO.getErrorMsg());
            }
            /* 校验完之后清除掉 */
            planShiftListMap.clear();
        }
        return Result.success(PublicConst.OP_SUCCESS);
    }

    private void convertToTimeNode(List<MultiDataDTO> planShiftListMap, List<ComShiftRule> shiftRuleList,
                                   boolean calcOnlyPerDay, boolean calcNextDay) {
        if (CollectionUtil.isEmpty(shiftRuleList)) {
            return;
        }
        for (ComShiftRule shiftRule : shiftRuleList) {
            /* 只要前一天的跨日的时间段 */
            if (calcOnlyPerDay) {
                if ("1".equals(shiftRule.getIsEndNextDay())) {
                    MultiDataDTO second = new MultiDataDTO();
                    second.setTimeNode("00:00:00-"
                            + DateUtil.format(shiftRule.getEndWorkTime(), DatePattern.NORM_TIME_FORMAT) + "_1");
                    planShiftListMap.add(second);
                }
            } else {
                if ("1".equals(shiftRule.getIsEndNextDay())) {
                    MultiDataDTO first = new MultiDataDTO();
                    first.setTimeNode(DateUtil.format(shiftRule.getStartWorkTime(), DatePattern.NORM_TIME_FORMAT)
                            + "-23:59:59_1");
                    planShiftListMap.add(first);
                    if (calcNextDay) {
                        MultiDataDTO second = new MultiDataDTO();
                        second.setTimeNode("00:00:00-"
                                + DateUtil.format(shiftRule.getEndWorkTime(), DatePattern.NORM_TIME_FORMAT) + "_1");
                        planShiftListMap.add(second);
                    }
                } else {
                    /* 没有跨日段，直接返回 */
                    if (calcNextDay) {
                        continue;
                    }
                    MultiDataDTO first = new MultiDataDTO();
                    first.setTimeNode(DateUtil.format(shiftRule.getStartWorkTime(), DatePattern.NORM_TIME_FORMAT) + "-"
                            + DateUtil.format(shiftRule.getEndWorkTime(), DatePattern.NORM_TIME_FORMAT) + "_1");
                    planShiftListMap.add(first);
                }
            }
        }
    }

    /**
     * 校验每个人每一天的考勤，且入库
     *
     * @param paramDTO
     * @return
     * @throws BusinessException
     */
    @Override
    public Result validateSinglePerShift(ParamDTO paramDTO) throws BusinessException {
        // 1、参数校验
        Long taskId = paramDTO.getComTaskId();
        ComTask comTask = checkTask(taskId);

        if (paramDTO.getPerId() == null) {
            throw new BusinessException(Result.ERROR, "人员id不能为空");
        }
        if (StrUtil.isEmpty(paramDTO.getDate())) {
            throw new BusinessException(Result.ERROR, "日期不能为空");
        }
        if (StrUtil.isEmpty(paramDTO.getTaskShiftType())) {
            throw new BusinessException(Result.ERROR, "排班类型不能为空");
        }
        if (StrUtil.isEmpty(paramDTO.getIds())) {
            throw new BusinessException(Result.ERROR, "班次id或周期id不能为空");
        }
        if (TASKSHIFTTYPE_ZQ.equals(paramDTO.getTaskShiftType())) {
            if (StrUtil.isEmpty(paramDTO.getEndDate())) {
                throw new BusinessException(Result.ERROR, "周期排班的截止日期不能为空");
            }
            if (DateUtil.parseDate(paramDTO.getEndDate()).after(comTask.getEndDate())) {
                throw new BusinessException(Result.ERROR, "周期排班的截止日期不能晚于任务截止日期");
            }
        }

        /* 判断当前选中的日期是否在 有效的任务时间区间内 */
        if (!DateUtil.isIn(DateUtil.parseDate(paramDTO.getDate()), comTask.getStartDate(), comTask.getEndDate())) {
            throw new BusinessException(Result.ERROR, "排班日期不能超出任务有效日期范围");
        }

        /* 当前人员是否在任务人员内 */
        boolean existsPer = false;
        List<MultiDataDTO> perList = comTaskShiftMapper.getCurrentPerByTask(taskId);
        for (MultiDataDTO dataDTO : perList) {
            if (dataDTO.getPerId().equals(paramDTO.getPerId())) {
                existsPer = true;
                break;
            }
        }
        if (!existsPer) {
            throw new BusinessException(Result.ERROR, "当前人员已经不在任务人员中");
        }

        /*** 校验时间段冲突  目前已经不需要校验时间冲突 by llc 2020-04-14 ***/

        List<String> perIdList = new ArrayList<>();
        perIdList.add(paramDTO.getPerId().toString());
        List<Map<String, String>> conflictSchedulList = comTaskSchedulMapper.getConflictSchedulList(paramDTO.getComTaskId(), paramDTO.getComId(), paramDTO.getDate(), perIdList);
        if(conflictSchedulList != null && conflictSchedulList.size() >0){
            return Result.fail("此人"+ paramDTO.getDate() + "在【"+ conflictSchedulList.get(0).get("taskNames")+"】存在排班记录!");
        }

        /* 插入排班表 */
        taskImplementInDB(paramDTO, comTask);

        return Result.success(PublicConst.OP_SUCCESS);
    }

    /**
     * 校验通过后，将任务排班当天的信息入库到 taskImplement
     *
     * @param paramDTO
     * @param comTask
     */
    private void taskImplementInDB(ParamDTO paramDTO, ComTask comTask) {
        /* 任务id */
        Long comTaskId = paramDTO.getComTaskId();
        /* 人员id */
        Long perId = paramDTO.getPerId();
        /* 日期 */
        String date = paramDTO.getDate();
        /* 周期id 或 班次id */
        String ids = paramDTO.getIds();
        List<String> shiftIdList = StrSplitter.split(ids, CommonConst.COMMA, true, true);

        List<ComTaskImplement> implementList = Lists.newArrayList();
        List<ComTaskSchedul> taskSchedulList = Lists.newArrayList();

        /* 2、设置排班信息 */
        /* 排班制排班 */
        if (TASKSHIFTTYPE_BC.equals(paramDTO.getTaskShiftType())) {

            /*** 删除这个人当天任务执行情况的排班情况 ***/
            comTaskImplementMapper.deleteImplementByTask(date, perId, comTaskId);

            /*** 删除这个人的排班制 by llc 2019-01-23 ***/
            comTaskSchedulMapper.deleteByPerTask(date, perId, comTaskId);

            /* 重新插入当天排班表的排班情况 */
            for (String shiftId : shiftIdList) {

                /*** 休息日，插入休息日的数据 by llc 2019-01-23***/
                if (Objects.equals(PublicConst.N, shiftId)) {
                    ComTaskImplement obj = packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId,
                            date, null, null, DictConst.ATTENDTYPE_PBZ, PublicConst.Y, paramDTO.getCreateBy());
                    ComTaskSchedul obj2 = packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId,
                            date, null, PublicConst.Y);
                    implementList.add(obj);
                    taskSchedulList.add(obj2);
                    continue;
                } else {
                    /* 同时插入轮次，如果一个班次有多个轮次，则插入多条记录 */
                    List<ComShiftRule> shiftRuleList = comShiftRuleMapper.getShiftRuleByShiftId(Long.parseLong(shiftId));
                    for (ComShiftRule shiftRule : shiftRuleList) {
                        /* 重新插入新的排班情况 */
                        ComTaskImplement obj = packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                                shiftId, shiftRule.getShiftRuleId(), DictConst.ATTENDTYPE_PBZ, PublicConst.N,
                                paramDTO.getCreateBy());
                        implementList.add(obj);
                    }
                    ComTaskSchedul obj2 = packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId, date,
                            shiftId, PublicConst.N);
                    taskSchedulList.add(obj2);
                }
            }
        }
        /* 周期排期 */
        else if (TASKSHIFTTYPE_ZQ.equals(paramDTO.getTaskShiftType())) {
            Date paramEndDate = DateUtil.parseDate(paramDTO.getEndDate());

            /* 删除这个人从当天起设置的结束日期的排班信息 */
            comTaskImplementMapper.deleteImplementByTaskInRange(date, paramDTO.getEndDate(), perId, comTaskId);
            comTaskSchedulMapper.deleteByPerTaskInRange(date, paramDTO.getEndDate(), perId, comTaskId);
            /* 周期 */
            ComTaskSchedulCycle cycle = comTaskSchedulCycleMapper.getByPrimaryKey(Long.parseLong(ids));
            /* 周期的班次 */
            List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper
                    .getTaskCycleShift(cycle.getTaskSchedulCycleId());
            /* 将周期的班次转换为 key:第几天 value:班次id1,班次id2 */
            Map<String, String> cycleShiftMap = cycleShiftListToMap(cycleShiftList);

            Map<String, List<ComShiftRule>> ruleMap = Maps.newHashMap();
            /* 循环周期的天数，一直循环到周期设定的任务结束日，如果一个周期完毕后还未到任务结束日，继续循环到周期设定的任务结束日 */
            int resetDay = 0;
            for (int loop = 1; loop <= Integer.MAX_VALUE; loop++) {
                /* 需要插入的日期 */
                DateTime appointDay = DateUtil.parseDate(paramDTO.getDate());

                /* 周期的第二天起 */
                if (loop > 1) {
                    /* 将日期累加到要校验的日期 */
                    appointDay = DateUtil.offsetDay(appointDay, loop - 1);
                }

                /* 判断最末的日期，如果周期计算的日期晚于当前日期，则不排班了 */
                if (appointDay.after(comTask.getEndDate())) {
                    break;
                }
                /* 已经循环到周期设定的结束日，不排班了 */
                if (appointDay.after(paramEndDate)) {
                    break;
                }

                /* 如果已经大于第一轮排班了，则重置轮次 */
                if (loop > cycle.getCycleDays()) {
                    resetDay = loop % cycle.getCycleDays();
                    /* 一个周期循环的最后一天 */
                    if (resetDay == 0) {
                        resetDay = cycle.getCycleDays();
                    }
                } else {
                    resetDay++;
                }

                String shiftId = cycleShiftMap.get(resetDay + "");
                String appointDayStr = DateUtil.formatDate(appointDay);
                /* 休息日，插入休息日的数据 */
                if (Objects.equals(REST_EN, shiftId)) {
                    ComTaskImplement obj = packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId,
                            appointDayStr, null, null, DictConst.ATTENDTYPE_PBZ, PublicConst.Y, paramDTO.getCreateBy());
                    ComTaskSchedul obj2 = packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId,
                            appointDayStr, null, PublicConst.Y);
                    implementList.add(obj);
                    taskSchedulList.add(obj2);
                    continue;
                }
                /* 同时插入轮次，如果一个班次有多个轮次，则插入多条记录 */
                if (CollectionUtil.isEmpty(ruleMap.get(shiftId))) {
                    List<ComShiftRule> shiftRuleList = comShiftRuleMapper
                            .getShiftRuleByShiftId(Long.parseLong(shiftId));
                    ruleMap.put(shiftId, shiftRuleList);
                }
                List<ComShiftRule> shiftRuleList = ruleMap.get(shiftId);
                for (ComShiftRule shiftRule : shiftRuleList) {
                    /* 重新插入新的排班情况 */
                    ComTaskImplement obj = packComTaskImplement(idWorker, paramDTO.getComId(), comTaskId, perId,
                            appointDayStr, shiftId, shiftRule.getShiftRuleId(), DictConst.ATTENDTYPE_PBZ, PublicConst.N,
                            paramDTO.getCreateBy());
                    implementList.add(obj);
                }
                ComTaskSchedul obj2 = packComTaskSchedule(idWorker, paramDTO.getComId(), comTaskId, perId,
                        appointDayStr, shiftId, PublicConst.N);
                taskSchedulList.add(obj2);
            }
        }

        /* 批量插入 */
        if (CollectionUtil.isNotEmpty(implementList)) {
            comTaskImplementMapper.insertBatch(implementList);
        }

        /* 批量插入 */
        if (CollectionUtil.isNotEmpty(taskSchedulList)) {
            comTaskSchedulMapper.insertBatch(taskSchedulList);

            /*** 同步百保盾 ***/
            paramDTO.setPerIds(paramDTO.getPerId().toString());
            bbdTestService.bbdSyncTaskSchedul(taskSchedulList,paramDTO);
        }

    }

    /**
     * 检查任务信息
     *
     * @param comTaskId 任务ID
     * @return ComTask 任务
     * @throws BusinessException The custom exception, contains bussness message.
     * @date 2017/12/26 13:59
     */
    private ComTask checkTask(Long comTaskId) throws BusinessException {
        // 检查任务id是否为空，为了预防空指针异常
        if (Objects.isNull(comTaskId)) {
            throw new BusinessException(Result.ERROR, "任务ID不可以为空");
        }
        // 检查任务是否存在
        ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskId);
        if (comTask == null) {
            throw new BusinessException(Result.ERROR, "任务不存在");
        }
        return comTask;
    }

    /**
     * 将周期的班次转换为 key:第几天 value:班次id1,班次id2
     *
     * @param cycleShiftList
     * @return
     */
    private Map<String, String> cycleShiftListToMap(List<MultiDataDTO> cycleShiftList) {
        Map<String, String> cycleShiftMap = Maps.newHashMap();
        cycleShiftList.forEach(cycleShift -> {
            String value = cycleShiftMap.get(cycleShift.getWhatDay());
            if (StrUtil.isEmpty(value)) {
                /* 休息日 */
                if (Objects.equals(cycleShift.getIsRest(), PublicConst.Y)) {
                    cycleShiftMap.put(cycleShift.getWhatDay(), REST_EN);
                } else {
                    cycleShiftMap.put(cycleShift.getWhatDay(), String.valueOf(cycleShift.getShiftId()));
                }
            } else {
                cycleShiftMap.put(cycleShift.getWhatDay(), value + CommonConst.COMMA + cycleShift.getShiftId());
            }
        });
        return cycleShiftMap;
    }

    /**
     * 组装 ComTaskImplement 对象，方便以后统一保存
     *
     * @param comTaskId
     * @param perId
     * @param date
     * @param shiftId
     * @param shiftRuleId
     * @param attendType
     * @param isRest
     */
    @Override
    public ComTaskImplement packComTaskImplement(IdWorker idWorker, Long comId, Long comTaskId, Long perId, String date,
                                                 String shiftId, Long shiftRuleId, String attendType, String isRest, Long createBy) {
        ComTaskImplement implement = new ComTaskImplement();
        implement.setTaskImplementId(idWorker.nextId());
        implement.setPerId(perId);
        if (StrUtil.isNotEmpty(shiftId)) {
            implement.setShiftId(Long.parseLong(shiftId));
        } else {
            implement.setShiftId(null);
        }
        implement.setDates(DateUtil.parseDate(date));
        implement.setComTaskId(comTaskId);
        implement.setShiftRuleId(shiftRuleId);
        implement.setAttendType(attendType);
        implement.setIsRest(isRest);
        if (comId == null) {
            comId = 0L;
        }
        implement.setComId(comId);
        implement.setWeekDay(DateUtils.dayOfWeek(date));
        implement.setCreateTime(new Date());
        implement.setCreateBy(createBy);
        return implement;
    }

    /**
     * 组装 ComTaskSchedul 对象，方便以后统一保存
     *
     * @param comTaskId
     * @param perId
     * @param date
     * @param shiftId
     * @param isRest
     */
    @Override
    public ComTaskSchedul packComTaskSchedule(IdWorker idWorker, Long comId, Long comTaskId, Long perId, String date,
                                              String shiftId, String isRest) {
        ComTaskSchedul schedule = new ComTaskSchedul();
        schedule.setTaskSchedulId(idWorker.nextId());
        schedule.setPerId(perId);
        if (StrUtil.isNotEmpty(shiftId)) {
            schedule.setShiftId(Long.parseLong(shiftId));
        } else {
            schedule.setShiftId(null);
        }
        if (comId == null) {
            comId = 0L;
        }
        schedule.setComId(comId);
        schedule.setSchedulDate(DateUtil.parseDate(date));
        schedule.setComTaskId(comTaskId);
        schedule.setIsRest(isRest);
        schedule.setCreateTime(new Date());
        return schedule;
    }

    /**
     * 检查排班是否和其他任务当天排班的时间点有冲突 流程： 1、遍历选择的日期当天的班次时间 2、通过数据库比对当天的班次时间是否有重合的时间点
     *
     * @author 罗鹏
     */
    private ShiftConflictResultDTO checkExistConflictShift(ParamDTO paramDTO, Date lastDate) throws BusinessException {
        /* 班次排期 */
        if (TASKSHIFTTYPE_BC.equals(paramDTO.getTaskShiftType())) {
            String ids = paramDTO.getIds();
            return validateShiftConflict(ids, paramDTO.getDate(), paramDTO.getPerId(), paramDTO.getComTaskId());
            //List<String> conflictList = validateShiftDateConflict(ids, paramDTO.getDate(), Lists.newArrayList(paramDTO.getPerId() + ""), paramDTO.getComTaskId(),paramDTO.getComId());
            //if (CollectionUtil.isNotEmpty(conflictList)) {
            //	ShiftConflictResultDTO dto = new ShiftConflictResultDTO();
            //	dto.setIsCorrect(false);
            //	dto.setErrorMsg("对不起，[" + paramDTO.getDate() + "]排班冲突，冲突信息：["
            //			+ conflictList.get(0) + "]，请调整排班后重试。");
            //	return dto;
            //}
        }
        /* 周期排期 */
        else if (TASKSHIFTTYPE_ZQ.equals(paramDTO.getTaskShiftType())) {
            String ids = paramDTO.getIds();
            String appointedDate = paramDTO.getDate();
            /* 周期 */
            ComTaskSchedulCycle cycle = comTaskSchedulCycleMapper.getByPrimaryKey(Long.parseLong(ids));
            /* 周期的班次 */
            List<MultiDataDTO> cycleShiftList = comTaskCycleShiftMapper
                    .getTaskCycleShift(cycle.getTaskSchedulCycleId());
            /* 将周期的班次转换为 key:第几天 value:班次id1,班次id2 */
            Map<String, String> cycleShiftMap = cycleShiftListToMap(cycleShiftList);

            /* 循环周期的天数，一直循环到月底，如果一个周期完毕后还未到月底，继续循环到月底 */
            int resetDay = 0;
            /* 循环周期的天数 */
            for (int loop = 1; loop <= 31; loop++) {
                /* 需要校验的日期 */
                DateTime validateDay = DateUtil.parseDate(appointedDate);
                /* 周期的第二天起 */
                if (loop > 1) {
                    /* 将日期累加到要校验的日期 */
                    validateDay = DateUtil.offsetDay(validateDay, loop - 1);
                }
                /* 判断最末的日期，如果周期计算的日期晚于当前日期，则不排班了 */
                if (validateDay.after(lastDate)) {
                    break;
                }
                /* 已经循环到月底，不排班了 */
                if (validateDay.after(DateUtil.endOfMonth(new Date()))) {
                    break;
                }
                /* 如果已经大于第一轮排班了，则重置轮次 */
                if (loop > cycle.getCycleDays()) {
                    resetDay = loop % cycle.getCycleDays();
                    /* 一个周期循环的最后一天 */
                    if (resetDay == 0) {
                        resetDay = cycle.getCycleDays();
                    }
                } else {
                    resetDay++;
                }

                String shiftIds = cycleShiftMap.get(resetDay + "");
                /* 休息日，不需要校验 */
                if (Objects.equals(REST_EN, shiftIds)) {
                    continue;
                }
                ShiftConflictResultDTO shiftDTO = validateShiftConflict(shiftIds, DateUtil.formatDate(validateDay),
                        paramDTO.getPerId(), paramDTO.getComTaskId());
                if (shiftDTO.getIsCorrect()) {
                    return shiftDTO;
                }
                //List<String> conflictList = validateShiftDateConflict(shiftIds, DateUtil.formatDate(validateDay),
                //		Lists.newArrayList(paramDTO.getPerId()+""), paramDTO.getComTaskId(),paramDTO.getComId());
                //if (CollectionUtil.isNotEmpty(conflictList)) {
                //	ShiftConflictResultDTO dto = new ShiftConflictResultDTO();
                //	dto.setIsCorrect(false);
                //	dto.setErrorMsg("对不起，[" + paramDTO.getDate() + "]排班冲突，冲突信息：["
                //			+ conflictList.get(0) + "]，请调整排班后重试。");
                //	return dto;
                //}
            }
            return new ShiftConflictResultDTO(true);
        }
        return new ShiftConflictResultDTO(false, null, "排期类型不正确");
    }

    /**
     * 校验人员当日排班和历史已排班是否有时间冲突（固定班次使用） s * @param date 校验的日期
     *
     * @param perId 人员id
     * @return ShiftConflictResultDTO
     * @throws ParseException
     */
    @Override
    public ShiftConflictResultDTO checkTaskFixed(String date, Long perId, Long comTaskId) throws BusinessException {
        List<String> planShiftList = new ArrayList<>();
        /* 获得在中间表中存在其他的任务排班记录 */
        // List<MultiDataDTO> midList = getPerMidShiftAppointedDate(date,
        // perId);
        /* 获得人员目前当天的排班情况，排班制 ************/
        List<MultiDataDTO> shiftedList = getPerShiftAppointedDate(date, perId, comTaskId);

        // planShiftList.addAll(timeNodeClassConvert(midList));
        planShiftList.addAll(timeNodeClassConvert(shiftedList));

        /* 获得人员在多少个固定班次中 */
        List<String> fixList = comTaskShiftMapper.selectPerShiftFixTask(date, perId);
        List<String> alreadyShiftList = comTaskShiftMapper.existsPerShiftTask(date, perId);
        /* 找到人员在未排班的固定班次中 */
        List<String> unShiftFixList = Lists.newArrayList();
        for (String str : alreadyShiftList) {
            if (fixList.contains(str)) {
                continue;
            }
            unShiftFixList.add(str);
        }

        /* 在固定班次中未进行排班 需要模拟排班 */
        if (CollectionUtil.isNotEmpty(unShiftFixList)) {
            /* 获得人员在固定排班中模拟的排班情况 */
            List<MultiDataDTO> mockShiftList = getMockShiftAppointedDate(date, perId, unShiftFixList);
            planShiftList.addAll(timeNodeClassConvert(mockShiftList));
        }

        ShiftConflictResultDTO conflictDTO2 = checkOverlap(planShiftList, String.valueOf(comTaskId));
        if (!conflictDTO2.getIsCorrect()) {
            ComTask conflictTask = comTaskMapper.getByPrimaryKey(Long.parseLong(conflictDTO2.getComTaskId()));
            conflictDTO2.setErrorMsg("对不起，[" + date + "]将要设置的[" + conflictDTO2.getPeriod() + "]与["
                    + conflictTask.getTaskName() + "]任务排班冲突，请调整任务排班后重试。");
            return conflictDTO2;
        }
        return conflictDTO2;
    }


    /**
     * 校验人员当日排班和历史已排班是否有时间冲突（当天的冲突，不需要校验时间段）
     *
     * @param shiftId 班次id
     * @param date    校验的日期
     * @param idList  人员id集合
     * @return ShiftConflictResultDTO
     * @throws ParseException
     */
    @Override
    public List<String> validateShiftDateConflict(String shiftId, String date, List<String> idList, Long comTaskId, Long comId)
            throws BusinessException {
        /* 过滤休息的班次 */
        if (StringUtil.isEmpty(shiftId) || "0".equals(shiftId)) {
            return Lists.newArrayList();
        }
        Long midTaskId = idWorker.nextId();
        List<ValidateTaskFixed> list = Lists.newArrayList();
        for (String id : idList) {
            ValidateTaskFixed fixed = new ValidateTaskFixed();
            fixed.setValidateTaskFixedId(idWorker.nextId());
            fixed.setPerId(Long.parseLong(id));
            list.add(fixed);
        }
        /* 插入校验表 */
        validateTaskFixedMapper.insertValidateTaskFixedDateList(list, comId, DictConst.ATTENDTYPE_PBZ, date, midTaskId);

        // 校验人员固定排班是否冲突,返回冲突的排班信息
        /* 进行排班冲突校验 ***/
        List<String> conflictList = validateTaskFixedMapper.checkPerTaskConflict(comId, comTaskId, midTaskId);

        /* 删除校验临时表信息 ***/
        validateTaskFixedMapper.deleteByPrimaryKey(midTaskId);

        return conflictList;
    }


    /**
     * 校验人员当日排班和历史已排班是否有时间冲突（时间段的冲突）
     *
     * @param shiftIds 班次ids
     * @param date     校验的日期
     * @param perId    人员id
     * @return ShiftConflictResultDTO
     * @throws ParseException
     */
    @Override
    public ShiftConflictResultDTO validateShiftConflict(String shiftIds, String date, Long perId, Long comTaskId)
            throws BusinessException {
        /* 选择的当天 */
        DateTime currentDay = DateUtil.parseDate(date);

        List<String> idList = StrSplitter.split(shiftIds, CommonConst.COMMA, true, true);
        List<MultiDataDTO> planShiftListMap = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(idList)) {
            planShiftListMap = comShiftRuleMapper.getTimeNodeByShiftIdList(idList);
            for (MultiDataDTO dataDTO : planShiftListMap) {
                dataDTO.setTimeNode(dataDTO.getTimeNode() + "_" + comTaskId);
            }
        }
        /* 先校验当前排班是否有重复区间 */
        List<String> allShiftList = Lists.newArrayList();
        List<String> planShiftList = timeNodeClassConvert(planShiftListMap);
        ShiftConflictResultDTO conflictDTO = checkOverlap(planShiftList, String.valueOf(comTaskId));
        if (!conflictDTO.getIsCorrect()) {
            ComTask conflictTask = comTaskMapper.getByPrimaryKey(Long.parseLong(conflictDTO.getComTaskId()));
            conflictDTO.setErrorMsg("对不起，[" + date + "]将要设置的[" + conflictDTO.getPeriod() + "]与["
                    + conflictTask.getTaskName() + "]任务排班冲突，请调整任务排班后重试。");
            return conflictDTO;
        }
        allShiftList.addAll(planShiftList);

        /* 获得人员目前当天的排班情况，排班制 ************/
        List<MultiDataDTO> shiftedList = getPerShiftAppointedDate(date, perId, comTaskId);

        /* 获得人员在多少个固定班次中 */
        List<String> fixList = comTaskShiftMapper.selectPerShiftFixTask(date, perId);
        List<String> alreadyShiftList = comTaskShiftMapper.existsPerShiftTask(date, perId);
        /* 找到人员在未排班的固定班次中 */
        List<String> unShiftFixList = Lists.newArrayList();
        for (String str : alreadyShiftList) {
            if (fixList.contains(str)) {
                continue;
            }
            unShiftFixList.add(str);
        }

        /* 在固定班次中未进行排班 需要模拟排班 */
        if (CollectionUtil.isNotEmpty(unShiftFixList)) {
            /* 获得人员在固定排班中模拟的排班情况 */
            List<MultiDataDTO> mockShiftList = getMockShiftAppointedDate(date, perId, unShiftFixList);
            allShiftList.addAll(timeNodeClassConvert(mockShiftList));
        }

        allShiftList.addAll(timeNodeClassConvert(shiftedList));

        ShiftConflictResultDTO conflictDTO2 = checkOverlap(allShiftList, String.valueOf(comTaskId));
        if (!conflictDTO2.getIsCorrect()) {
            ComTask conflictTask = comTaskMapper.getByPrimaryKey(Long.parseLong(conflictDTO2.getComTaskId()));
            conflictDTO2.setErrorMsg("对不起，[" + date + "]将要设置的[" + conflictDTO2.getPeriod() + "]与["
                    + conflictTask.getTaskName() + "]任务排班冲突，请调整任务排班后重试。");
            return conflictDTO2;
        }

        /* 需要考虑跨日，后一天的情况 */
        int hasNextDay = comShiftRuleMapper.hasNextDay(idList);
        if (hasNextDay == 0) {
            return conflictDTO2;
        }

        planShiftListMap.clear();
        allShiftList.clear();
        shiftedList.clear();
        fixList.clear();
        alreadyShiftList.clear();
        unShiftFixList.clear();

        /* 拿到当前班次跨日的部分 */
        planShiftListMap = comShiftRuleMapper.getNextDayTimeNodeByShiftId(idList);
        for (MultiDataDTO dataDTO : planShiftListMap) {
            dataDTO.setTimeNode(dataDTO.getTimeNode() + "_" + comTaskId);
        }
        allShiftList.addAll(timeNodeClassConvert(planShiftListMap));
        /* 明天 */
        DateTime tomorrowDate = DateUtil.offsetDay(currentDay, 1);
        String tomorrow = DateUtil.format(tomorrowDate, DatePattern.NORM_DATE_FORMAT);
        /* 拿到已排班表中后一天的白天部分 */
        shiftedList = comTaskImplementMapper.getAppointedImplementDataIdByDate(perId, tomorrow);

        /* 获得人员在多少个固定班次中 */
        fixList = comTaskShiftMapper.selectPerShiftFixTask(tomorrow, perId);
        alreadyShiftList = comTaskShiftMapper.existsPerShiftTask(tomorrow, perId);
        /* 找到人员在未排班的固定班次中 */
        unShiftFixList = Lists.newArrayList();
        for (String str : alreadyShiftList) {
            if (fixList.contains(str)) {
                continue;
            }
            unShiftFixList.add(str);
        }
        /* 在固定班次中未进行排班 需要模拟排班 */
        if (CollectionUtil.isNotEmpty(unShiftFixList)) {
            /* 获得人员在固定排班中模拟的排班情况 */
            List<MultiDataDTO> mockShiftList = getMockShiftAppointedNextDate(tomorrowDate, tomorrow, perId,
                    unShiftFixList);
            allShiftList.addAll(timeNodeClassConvert(mockShiftList));
        }
        allShiftList.addAll(timeNodeClassConvert(shiftedList));
        ShiftConflictResultDTO conflictDTO3 = checkOverlap(allShiftList, String.valueOf(comTaskId));
        if (!conflictDTO3.getIsCorrect()) {
            ComTask conflictTask = comTaskMapper.getByPrimaryKey(Long.parseLong(conflictDTO3.getComTaskId()));
            conflictDTO3.setErrorMsg("对不起，[" + date + "]将要设置的[" + conflictDTO3.getPeriod() + "]与["
                    + conflictTask.getTaskName() + "]任务排班冲突，请调整任务排班后重试。");
            return conflictDTO3;
        }
        return conflictDTO3;
    }

    /**
     * 获得指定日期当天的排班信息
     *
     * @param appointedDate
     * @return
     */
    private List<MultiDataDTO> getPerShiftAppointedDate(String appointedDate, Long perId, Long comTaskId) {
        /* 选择的当天 */
        DateTime currentDay = DateUtil.parseDate(appointedDate);
        /* 选择的昨天 需要考虑前一天的情况 */
        DateTime yesterday = DateUtil.offsetDay(currentDay, -1);
        return comTaskShiftMapper.getPerShiftCurrentDate(DateUtil.formatDate(yesterday), appointedDate, perId,
                comTaskId);
    }

    /**
     * 获得固定排班中模拟日期的排班信息
     *
     * @param appointedDate
     * @return
     */
    private List<MultiDataDTO> getMockShiftAppointedDate(String appointedDate, Long perId,
                                                         List<String> noShiftFixList) {
        /* 选择的当天 */
        DateTime currentDay = DateUtil.parseDate(appointedDate);
        /* 选择的昨天 需要考虑前一天的情况 */
        DateTime yesterday = DateUtil.offsetDay(currentDay, -1);
        /* 得到选定日期的班次情况 */
        int currentDayOfWeek = DateUtil.weekOfMonth(currentDay);
        int yesterdayOfWeek = DateUtil.weekOfMonth(yesterday);

        return comTaskShiftMapper.getMockShiftCurrentDate(appointedDate, yesterdayOfWeek, currentDayOfWeek, perId,
                noShiftFixList);
    }

    /**
     * 获得固定排班中模拟日期当天白天排班的情况
     *
     * @param appointedDate
     * @return
     */
    private List<MultiDataDTO> getMockShiftAppointedNextDate(Date appointedDate, String appointedDateStr, Long perId,
                                                             List<String> noShiftFixList) {
        int dayOfWeek = DateUtil.weekOfMonth(appointedDate);
        return comTaskShiftMapper.getMockShiftAppointedNextDate(appointedDateStr, dayOfWeek, perId, noShiftFixList);
    }

    /**
     * 检查时间范围是否有重合
     *
     * @param list 时间点列表
     *             <p>
     *             格式： "08:00:00-12:00:00" "12:00:00-13:00:00"
     *             </p>
     * @return ShiftConflictResultDTO
     * @date 2017-12-29 09:29 PM
     */
    private static ShiftConflictResultDTO checkOverlap(List<String> list, String currentTaskId)
            throws BusinessException {
        Map<String, String> map = Maps.newHashMap();
        List<String> newList = Lists.newArrayList();
        for (String str : list) {
            List<String> tempList = StrSplitter.split(str, "_", true, true);
            map.put(tempList.get(0), tempList.get(1));
            newList.add(tempList.get(0));
        }
        try {
            ShiftConflictResultDTO dto = new ShiftConflictResultDTO();
            // 排序ASC
            Collections.sort(newList);

            // 是否成功
            boolean flag = true;
            for (int i = 0; i < newList.size(); i++) {
                if (i > 0) {
                    // 跳过第一个时间段不做判断
                    String[] itime = newList.get(i).split("-");
                    for (int j = 0; j < newList.size(); j++) {
                        // 如果当前遍历的i开始时间小于j中某个时间段的结束时间那么则有重叠，反之没有重叠
                        // 这里比较时需要排除i本身以及i之后的时间段，因为已经排序了所以只比较自己之前(不包括自己)的时间段
                        if (j == i || j > i) {
                            continue;
                        }

                        String[] jtime = newList.get(j).split("-");
                        // 此处DateUtils.compare为日期比较(返回负数date1小、返回0两数相等、返回正整数date1大)
                        int compare = compare((DateUtils.getDate() + " " + itime[0] + ":00"),
                                (DateUtils.getDate() + " " + jtime[1] + ":00"), "yyyy-MM-dd HH:mm:ss");
                        if (compare < 0) {
                            dto.setPeriod(newList.get(i));
                            /* 不能是当前任务id，应该提起其他任务 */
                            if (currentTaskId.equals(map.get(newList.get(i)))) {
                                dto.setComTaskId(map.get(newList.get(j)));
                            } else {
                                dto.setComTaskId(map.get(newList.get(i)));
                            }
                            flag = false;
                            break;// 只要存在一个重叠则可退出内循环
                        }
                    }
                }
                // 当标识已经认为重叠了则可退出外循环
                if (!flag) {
                    break;
                }
            }

            dto.setIsCorrect(flag);
            return dto;
        } catch (ParseException p) {
            p.printStackTrace();
        }
        throw new BusinessException(Result.ERROR, "日期转换异常");
    }

    /**
     * 时间对比
     *
     * @param time1
     * @param time2
     * @param timeFormat
     * @return int 负数date1小、返回0两数相等、返回正整数date1大
     * @date 2017-12-29 09:31 PM
     */
    private static int compare(String time1, String time2, String timeFormat) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timeFormat);
        Date date1 = simpleDateFormat.parse(time1);
        Date date2 = simpleDateFormat.parse(time2);
        if (date1.before(date2)) {
            return -1;
        }
        if (date1.after(date2)) {
            return 1;
        }
        return 0;
    }

    /**
     * 将List<MultiDataDTO>转换为List<String>，仅支持 timeNode
     *
     * @param dataList
     * @return
     */
    private List<String> timeNodeClassConvert(List<MultiDataDTO> dataList) {
        if (CollectionUtil.isEmpty(dataList)) {
            return Lists.newArrayList();
        }
        List<String> newList = Lists.newArrayList();
        dataList.forEach(data -> {
            newList.add(data.getTimeNode());
        });
        return newList;
    }

}