package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.dto.ComShiftDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

/**
 * 企业班次
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
public interface ComShiftService {
    /**
     * 班次管理分页查询
     * @Author: zhongjianhui
     * @Description:班次管理分页查询
     * @Date: 2018/02/26 17:47
     */
    Result pageForShift(ComShiftDto comShiftDto);

    /**
     * @Author: wuxiaozhen
     * @Description:班次管理删除班次
     * @Date: 2018/02/26 14:05
     */
    Result delete(ComShiftDto comShiftDto)throws BusinessException;

    /**
     * 添加班次
     * @Author: zhongjianhui
     * @Description:新增班次管理
     * @param comShiftDto
     * @throws BusinessException
     */
    Result addShift(ComShiftDto comShiftDto) throws BusinessException;

    /**
     * 添加班次
     * @Author: zhongjianhui
     * @Description:编辑班次管理
     * @param comShiftDto
     * @throws BusinessException
     */
    Result updateShift(ComShiftDto comShiftDto) throws BusinessException;

    /**
     * @Author: zhongjianhui
     * @Description:班次详细信息查询
     * @param comShiftDto
     * @Date: 2018/02/26 14:05
     */
    Result getByPrimaryKey(ComShiftDto comShiftDto);

}