package com.bcxin.oa.old.service.system;


import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.dto.ComSocialInsSchemeDTO;
import com.bcxin.oa.old.dto.MedicalSocialRecDTO;
import com.bcxin.oa.old.dto.PaymentSettingDTO;
import com.bcxin.oa.old.dto.PaymentSettingListDTO;

import java.util.List;
import java.util.Map;

/**
 * @Author: 陈堂君
 * @Date: 2017/12/22
 * @Description:
 * @Modified By:
 */
public interface MedicalSocialRecService {

    /**
     * 定时任务，按指定时间生成上月的数据
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/27 9:54
     */
    Result taskGenerateHisRec(Map p) throws BusinessException;
    /**
     *  提示用户设置方案
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/27 22:28
     */
    Result promptUserToSetScheme(MedicalSocialRecDTO dto);
    /**
     * 获得医社保缴费记录查询
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 10:31
     */
    Result getHisRecListPage(MedicalSocialRecDTO dto) throws BusinessException;

    /**
     * 获得医社保缴费记录查询 导出
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/25 17:29
     */
    List<Map<String, Object>> getHisRecListPageExport(MedicalSocialRecDTO dto);

    /**
     * 医社保 缴费记录统计按月
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 10:31
     */
    Result statHisRecList(MedicalSocialRecDTO dto) throws BusinessException;

    /**
     *  查询人员缴交情况分页
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 10:48
     */
    Result getPaymentSettingPage(PaymentSettingListDTO dto) throws BusinessException;
    /**
     * 删除缴费设置
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 10:50
     */
    Result delPaymentSetting(PaymentSettingListDTO dto) throws BusinessException;

    /**
     * 添加人员，插入关系数据
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:05
     */
    Result addPerson(PaymentSettingDTO dto);
    /**
     * 移除人员，删除关系数据
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:06
     */
    Result delPerson(PaymentSettingDTO dto);
    /**
     * 人员选择列表分页，根据企业ID和缴交方案ID查询出本公司的所有人员
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:06
     */
    Result multiselPersonPage(ComSocialInsSchemeDTO dto) throws BusinessException;
    /**
     * 缴交方案新增和修改，一对多5险
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:06
     */
    Result savePaymentSetting(ComSocialInsSchemeDTO dto) throws BusinessException;

    /**
     * 缴交方案详情查询，通过缴交方案ID
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:06
     */
    Result getPaymentSettingById(ComSocialInsSchemeDTO dto);
    /**
     * 某个缴交方案的已选人员列表,通过缴交方案ID
     * @apiNote  作者  陈堂君
     * @since 创建于 2017/12/22 11:07
     */
    Result getSelectedPersonPage(ComSocialInsSchemeDTO dto);

}
