package com.bcxin.oa.old.service.attend.app;

import com.bcxin.oa.old.common.DictConst;
import com.bcxin.oa.old.common.utils.DateUtils;
import com.bcxin.oa.old.mapper.ComAttendAddressMapper;
import com.bcxin.oa.old.mapper.app.ComAttendMapper;
import com.bcxin.oa.old.entity.task.ComAttendAddress;
import com.bcxin.oa.old.dto.app.AppComAttendDTO;
import com.bcxin.oa.old.dto.app.AppComAttendExceptionDTO;
import com.bcxin.oa.old.dto.app.AppComAttendShiftDTO;
import com.bcxin.oa.old.dto.app.AppComAttendSmallShiftDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.service.common.CommonService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * APP企业考勤列表
 *
 * @author zhangye
 * @since 2018-02-26 10:47:41
 */
@Service
@Transactional
public class ComAttendServiceImpl implements ComAttendService {
	@Resource
	private ComAttendMapper comAttendMapper;
	@Resource
	private CommonService commonService;

	@Resource
	private ComAttendAddressMapper comAttendAddressMapper;

	@Override
	public Result listComAttend(AppComAttendDTO appComAttendDTO) throws BusinessException {

		/***
		 * 1.返回人员的当月所有打卡记录 2.查询人员日期打卡 3.
		 *
		 */
		String selectDate = "";
		// 如果没传递请求显示年或者请求显示月，则默认取当前日期
		if (appComAttendDTO.getYear() == null || appComAttendDTO.getMonth() == null) {
			selectDate = DateUtils.getDate();
		} else {
			// 如果有传递请求显示年或者请求显示月，则默认取传递年月的1号
			selectDate = appComAttendDTO.getYear() + "-" + appComAttendDTO.getMonth() + "-" + "01";
		}
		appComAttendDTO.setSelectDate(selectDate);
		AppComAttendDTO appComAttendDTOResult = comAttendMapper.getComAttend(appComAttendDTO);
		appComAttendDTOResult.setSelectDate(selectDate);
		appComAttendDTOResult.setPerId(appComAttendDTO.getPerId());
		appComAttendDTOResult.setComId(appComAttendDTO.getComId());
		// 获取考勤班次信息
		List<AppComAttendShiftDTO> arrShifts = comAttendMapper.getComAttendShiftList(appComAttendDTOResult);
		Date currentDate = new Date(); // 系统当前日期
		List<AppComAttendExceptionDTO> arrExceptionAttendance = new ArrayList<AppComAttendExceptionDTO>();// 异常考勤列表
		if (arrShifts != null && arrShifts.size() > 0) {
			// 获取考勤地点列表
			Long attendGroupId = arrShifts.get(arrShifts.size() - 1).getAttendGroupId();
			List<ComAttendAddress> arrCoords = comAttendAddressMapper.listAttendGroupAddress(attendGroupId);
			if (arrCoords != null && arrCoords.size() > 0) {
				appComAttendDTOResult.setArrCoords(arrCoords);
				appComAttendDTOResult.setScope(arrCoords.get(0).getAddressRange());
			}
			// 考勤补卡模板状态
			String isActiveStr = comAttendMapper.getIsActive(appComAttendDTO.getComId(), "15");
			int isActive = 0;
			if (StringUtils.isNotEmpty(isActiveStr)) {
				isActive = Integer.parseInt(isActiveStr);
			}
			// 最近可上班班次
			AppComAttendSmallShiftDTO nearGoToWorkComAttendSmallShift = null;
			// 最近可下班班次
			AppComAttendSmallShiftDTO nearGoOffWorkComAttendSmallShift = null;
			// 获取考勤班次轮次信息
			for (AppComAttendShiftDTO appComAttendShiftDTO : arrShifts) {
				appComAttendShiftDTO.setIsActive(isActive);// 只有异常才有补卡情况，才需要确定补卡状态
				boolean exception = false;// 是否存在异常考勤
				int exceptDay = appComAttendShiftDTO.getDay();// IOS异常日期(日)
				Date exceptDate = null; // 安卓异常日期(年月日)
				try {
					exceptDate = DateUtils.parseDate(appComAttendShiftDTO.getShiftDate(), "yyyy-MM-dd");
				} catch (Exception e) {

				}
				Long shiftId = appComAttendShiftDTO.getShiftId();
				String shiftTime = commonService.listChangeToString(shiftId, false, false);
				appComAttendShiftDTO.setShiftTime(shiftTime);
				appComAttendShiftDTO.setPerId(appComAttendDTO.getPerId());
				List<AppComAttendSmallShiftDTO> arrSmallShifts = comAttendMapper
						.getComAttendSmallShiftList(appComAttendShiftDTO);
				// 最近可签到班次
				if (arrSmallShifts != null && arrSmallShifts.size() > 0) {
					int index = 0;
					for (AppComAttendSmallShiftDTO appComAttendSmallShiftDTO : arrSmallShifts) {
						// Date startWorkDate =
						// appComAttendSmallShiftDTO.getStartWorkDate();//
						// 可上班打卡日期
						Date endWorkDate = appComAttendSmallShiftDTO.getEndWorkDate();// 可下班打卡日期

						// 判断当前系统时间是否大于最近可上班班次时间开始时间，如果大于，则设置可下班班次为漏打卡并且结束状态
						if (currentDate.getTime() >= appComAttendSmallShiftDTO.getStartWorkDate().getTime()
								&& nearGoOffWorkComAttendSmallShift != null) {
							if (nearGoOffWorkComAttendSmallShift.getSignOutStatus() == null
									|| nearGoOffWorkComAttendSmallShift.getSignOutStatus() == 0) {
								nearGoOffWorkComAttendSmallShift
										.setSignOutStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QK));
							}
							nearGoOffWorkComAttendSmallShift
									.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC));
							nearGoOffWorkComAttendSmallShift = null;
						}

						// 比较轮次打开年月是否大于当前系统年月，则设置打卡状态为“未开始”
						if (appComAttendSmallShiftDTO.getSmallShiftType() == Integer
								.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
							Long d1 = Long.valueOf(
									DateUtils.formatDate(appComAttendSmallShiftDTO.getStartDate(), "yyyyMMdd"));
							Long d2 = Long.valueOf(DateUtils.formatDate(currentDate, "yyyyMMdd"));
							if (d1 > d2) {
								appComAttendSmallShiftDTO
										.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS));
							}
						}
						// 最近可上班班次
						if (appComAttendSmallShiftDTO.getSmallShiftType() == Integer
								.valueOf(DictConst.SMALLSHIFTTYPE_KQD)) {
							if (nearGoToWorkComAttendSmallShift == null) {
								nearGoToWorkComAttendSmallShift = appComAttendSmallShiftDTO;
							} else {
								// 如果已经存在可以打卡班次，则设置其他可签到的班次为“未开始”状态
								appComAttendSmallShiftDTO
										.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS));
							}
						}
						// 当前时间大于等于班次下班时间,下班未打卡或者下班时请假状态,则设置可下班状态
						if (currentDate.getTime() >= endWorkDate.getTime() && appComAttendSmallShiftDTO
								.getSmallShiftType() != Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC)) {
							if (appComAttendSmallShiftDTO.getSignOutStatus() == null || appComAttendSmallShiftDTO
									.getSignOutStatus() == Integer.valueOf(DictConst.ATTENDSTATUS_QJ)) {
								appComAttendSmallShiftDTO
										.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB));
							}
						}
						// 如果为可下班，则判断下一轮次是否已经开始了，如果已经开始了，则自动设置该班次为漏打卡，并设置完成状态
						if (appComAttendSmallShiftDTO.getSmallShiftType() == Integer
								.valueOf(DictConst.SMALLSHIFTTYPE_KXB)) {
							if (arrSmallShifts.size() != (index + 1)) {
								// 有下一轮考勤，则判断下一轮考勤与当前时间比较，如果已经进入下一轮打卡时间，则当前论次需要设置漏打卡，否则当前轮次可以打下班卡，下一轮次未开始
								AppComAttendSmallShiftDTO nextAttendSmallShift = arrSmallShifts.get(index + 1);
								if (currentDate.getTime() >= nextAttendSmallShift.getStartWorkDate().getTime()) {
									appComAttendSmallShiftDTO
											.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC));
									if (appComAttendSmallShiftDTO.getSignOutStatus() == null
											|| appComAttendSmallShiftDTO.getSignOutStatus() == 0) {
										appComAttendSmallShiftDTO
												.setSignOutStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QK));
									}
								} else {
									appComAttendSmallShiftDTO
											.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB));
									nextAttendSmallShift
											.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS));
									if (nearGoToWorkComAttendSmallShift == null) {
										nearGoToWorkComAttendSmallShift = appComAttendSmallShiftDTO;
									}
								}
							}
						}

						// 迟到
						if (exception == false && appComAttendSmallShiftDTO.getSignInStatus() == Integer
								.valueOf(DictConst.ATTENDSTATUS_CD)) {
							exception = true;
						}
						// 缺岗
						if (appComAttendSmallShiftDTO.getSignInStatus() == Integer.valueOf(DictConst.ATTENDSTATUS_QK)) {
							exception = true;
						}
						// 请假
						if (exception == false && appComAttendSmallShiftDTO.getSignInStatus() == Integer
								.valueOf(DictConst.ATTENDSTATUS_QJ)) {
							exception = true;
						}

						// 早退
						if (exception == false && appComAttendSmallShiftDTO.getSignOutStatus() == Integer
								.valueOf(DictConst.ATTENDSTATUS_ZT)) {
							exception = true;
						}
						// 漏卡
						if (exception == false && appComAttendSmallShiftDTO.getSignOutStatus() == Integer
								.valueOf(DictConst.ATTENDSTATUS_QK)) {
							exception = true;
						}
						// 请假
						if (exception == false && appComAttendSmallShiftDTO.getSignOutStatus() == Integer
								.valueOf(DictConst.ATTENDSTATUS_QJ)) {
							exception = true;
						}

						if (appComAttendSmallShiftDTO.getSignInStatus() == null) {
							appComAttendSmallShiftDTO.setSignInStatus(0);
						}
						if (appComAttendSmallShiftDTO.getSignOutStatus() == null) {
							appComAttendSmallShiftDTO.setSignOutStatus(0);
						}

						// 设置最近可下班班次
						if (appComAttendSmallShiftDTO.getSmallShiftType() == Integer
								.valueOf(DictConst.SMALLSHIFTTYPE_KXB)) {
							if (nearGoOffWorkComAttendSmallShift == null) {
								nearGoOffWorkComAttendSmallShift = appComAttendSmallShiftDTO;
							} else {
								// 判断当前系统时间是否大于最近可上班班次时间开始时间，如果大于，则设置可下班班次为漏打卡并且结束状态
								if (nearGoToWorkComAttendSmallShift != null && currentDate
										.getTime() >= nearGoToWorkComAttendSmallShift.getStartWorkDate().getTime()) {
									if (nearGoOffWorkComAttendSmallShift.getSignOutStatus() == null
											|| nearGoOffWorkComAttendSmallShift.getSignOutStatus() == 0) {
										nearGoOffWorkComAttendSmallShift
												.setSignOutStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QK));
									}
									nearGoOffWorkComAttendSmallShift
											.setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC));
									nearGoOffWorkComAttendSmallShift = null;
								}
							}
						}
						// // 上下班都是漏卡，则把这个班次设置成完成状态
						// if (appComAttendSmallShiftDTO.getSignInStatus() ==
						// Integer.valueOf(DictConst.ATTENDSTATUS_QK)
						// && appComAttendSmallShiftDTO.getSignOutStatus() ==
						// Integer
						// .valueOf(DictConst.ATTENDSTATUS_QK)
						// && appComAttendSmallShiftDTO.getSmallShiftType() !=
						// Integer
						// .valueOf(DictConst.SMALLSHIFTTYPE_YWC)) {
						// // 判断是否还有下一轮次考勤，如果没有则设置下班可以打卡,如果有，则判断下一个班次
						// if (arrSmallShifts.size() == (index + 1)) {
						// // 无下一轮次考勤，则设置当前考勤可以下班
						// appComAttendSmallShiftDTO
						// .setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB));
						// appComAttendSmallShiftDTO.setSignOutStatus(0);
						// } else {
						// //
						// 有下一轮考勤，则判断下一轮考勤与当前时间比较，如果已经进入下一轮打卡时间，则当前论次需要设置漏打卡，否则当前轮次可以打下班卡，下一轮次未开始
						// Date toDate = new Date(); // 系统当前日期
						// AppComAttendSmallShiftDTO nextAttendSmallShift =
						// arrSmallShifts.get(index + 1);
						// if (toDate.getTime() >=
						// nextAttendSmallShift.getStartWorkDate().getTime()) {
						// appComAttendSmallShiftDTO
						// .setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_YWC));
						// } else {
						// appComAttendSmallShiftDTO
						// .setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_KXB));
						// appComAttendSmallShiftDTO.setSignOutStatus(0);
						// nextAttendSmallShift
						// .setSmallShiftType(Integer.valueOf(DictConst.SMALLSHIFTTYPE_WKS));
						// }
						// }
						// }

						index++;
					}
				}

				if (exception) {
					AppComAttendExceptionDTO attendException = new AppComAttendExceptionDTO();
					attendException.setDay(exceptDay);
					attendException.setDate(exceptDate);
					attendException.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));// 异常
					arrExceptionAttendance.add(attendException);
				}
				appComAttendShiftDTO.setArrSmallShifts(arrSmallShifts);
			}
		}
		/**
		 * 所有班次状态均为正常，则日历显示班 所有班次状态均为漏签，则日历显示缺 班次存在多种状态，则日历显示异，所有班次状态为请假，则日历显示假
		 */
		//
		// if (arrExceptionAttendance != null && arrExceptionAttendance.size() >
		// 0) {
		// Map<Integer, AppComAttendExceptionDTO> map = new HashMap<Integer,
		// AppComAttendExceptionDTO>();
		// // 是否全部缺勤状态
		// for (AppComAttendExceptionDTO item : arrExceptionAttendance) {
		// if (map == null || map.size() < 1) {
		// if (item.getAttendStatus() !=
		// Integer.valueOf(DictConst.ATTENDSTATUS_QG)) {
		// if (item.getAttendStatus() ==
		// Integer.valueOf(DictConst.ATTENDSTATUS_QJ)) {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QJ)); //
		// 请假
		// } else {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD)); //
		// 异常
		// }
		// } else {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QG)); //
		// 缺岗
		// }
		// map.put(item.getDay(), item);
		// } else {
		// if (item.getAttendStatus() !=
		// Integer.valueOf(DictConst.ATTENDSTATUS_QG)) {
		// if (item.getAttendStatus() ==
		// Integer.valueOf(DictConst.ATTENDSTATUS_QJ)) {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QJ)); //
		// 请假
		// } else {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD)); //
		// 异常
		// }
		// } else {
		// item.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_QG)); //
		// 缺岗
		// }
		// if (map.containsKey(item.getDay())) {
		// AppComAttendExceptionDTO exits = map.get(item.getDay());
		// if (exits.getAttendStatus() != item.getAttendStatus()) {
		// if (exits.getAttendStatus() !=
		// Integer.valueOf(DictConst.ATTENDSTATUS_CD)) {
		// exits.setAttendStatus(Integer.valueOf(DictConst.ATTENDSTATUS_CD));
		// }
		// }
		// } else {
		// map.put(item.getDay(), item);
		// }
		// }
		// }
		// if (map != null && map.size() > 0) {
		// arrExceptionAttendance.clear();
		// for (Map.Entry<Integer, AppComAttendExceptionDTO> m : map.entrySet())
		// {
		// arrExceptionAttendance.add(m.getValue());
		// }
		// }
		// }
		appComAttendDTOResult.setArrShifts(arrShifts);
		appComAttendDTOResult.setArrExceptionAttendance(arrExceptionAttendance);
		return Result.success(Result.SUCCESS_MSG, appComAttendDTOResult);
	}

}