package com.bcxin.oa.old.mapper.tempTask;

import com.bcxin.oa.old.entity.task.tempTask.ComTempTask;
import com.bcxin.oa.old.dto.tempTask.ComTempTaskDto;
import com.bcxin.oa.old.dto.tempTask.ComTempTaskResultDto;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 临保任务mapper
 *
 * @author llc
 * @date 2020-02-24
 */
public interface ComTempTaskMapper extends CrudDao<ComTempTask> {

    /**
     * 插入临保任务
     * @param comTempTask
     * @author llc
     * @date 2020-02-24
     * @return
     */
    int insertTempTask(ComTempTask comTempTask);


    /**
     * 更新临保任务
     * @param comTempTask
     * @author llc
     * @date 2020-02-24
     * @return
     */
    int updateTempTask(ComTempTask comTempTask);


    /**
     * 删除临保任务
     * @param comTempTask
     * @author llc
     * @date 2020-02-24
     * @return
     */
    int deleteTempTask(ComTempTask comTempTask);



    /**
     * 获取临保任务详情
     * @param comTempTaskId
     * @author llc
     * @date 2020-02-24
     * @return
     */
    ComTempTaskDto getComTempTaskById(@Param("comTempTaskId")Long comTempTaskId);


    /**
     * 获取发布临保任务列表（发布企业）
     * @param comTempTask
     * @author llc
     * @date 2020-02-24
     * @return
     */
    List<ComTempTaskResultDto> getReleaseTempTaskList(ComTempTask comTempTask);


    /**
     * 获取共享临保任务列表（共享企业）
     * @param comTempTask
     * @author llc
     * @date 2020-02-24
     * @return
     */
    List<ComTempTaskResultDto> getShareTempTaskList(ComTempTask comTempTask);


    /**
     * 查询任务负责人信息
     *
     * @param comTempTask
     * @author llc
     * @date: 2020-03-10
     */
    Map<String,String> getChargePerInfo(ComTempTask comTempTask);


    /**
     * 定时器更新任务状态
     *
     * @author llc
     * @date: 2020-03-18
     */
    Integer updateAllTaskStatus();


    /**
     * 查询临保任务列表
     * @author llc
     * @date 2020-03-25
     * @param dto
     * @return
     */
    List<Map<String,Object>> getComTempTaskList(ComTempTaskDto dto);


    /**
     * 获取公司临保任务驻勤点类型
     *
     * @param dto
     * @author llc
     * @date: 2020-03-26
     */
    List<Map<String,Object>> getComTempTaskStationType(ComTempTaskDto dto);


    /**
     * 防控指挥获取临保任务人员位置
     * @param dto
     * @author llc
     * @date 2020-03-26
     * @return
     */
    List<Map<String,Object>> getComTempTaskPerLocation(ComTempTaskDto dto);


}