package com.bcxin.oa.old.mapper.attend;


import com.bcxin.oa.old.entity.count.CountPerAttendDate;
import com.bcxin.oa.old.dto.CountPerAttendDTO;
import com.bcxin.oa.old.dto.ExportPerAttendMonthDTO;
import com.bcxin.oa.old.dto.ParamDTO;
import com.bcxin.oa.old.dto.PerAttendDateDTO;
import com.bcxin.oa.old.dto.count.AppPerAttendCountResultDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员考勤日统计
 *
 * @author llc
 * @date 2018-12-03
 */
public interface CountPerAttendDateMapper extends CrudDao<CountPerAttendDate> {


    /**
     * 生成统计考勤数据
     * @author llc
     * @date 2018-12-17
     * @param paramMap
     * @return
     */
    Map<String, String> prc_createAttendCountReport(Map<String, Object> paramMap);


    /**
     * 获取人员考勤日统计情况
     * @author llc
     * @date 2018-12-03
     * @param dto
     * @return
     */
    List<Map<String,Object>> getPerAttendDateCountList(CountPerAttendDTO dto) ;


    /**
     * 获取人员考勤月统计情况
     * @author llc
     * @date 2018-12-03
     * @param dto
     * @return
     */
    List<ExportPerAttendMonthDTO> getPerAttendMonthCountList(CountPerAttendDTO dto) ;

    /**
     * 获得个人月统计数据
     * @param dto
     * @return
     */
    ExportPerAttendMonthDTO getPerAttendMonthCount(ParamDTO dto);

    /**
     * 获取公司名称
     * @author llc
     * @date 2018-12-03
     * @param comId
     * @return
     */
    String getComNameByComId(@Param("comId") Long comId);


    /**
     * 获取人员基本信息
     * @author llc
     * @date 2018-12-06
     * @param perId
     * @return
     */
     Map<String,String> getPerBaseInfo(@Param("perId") Long perId);


    /**
     * 查询人员某日打卡详情
     * @author llc
     * @date 2018-12-06
     * @param dto
     * @return
     */
    List<Map<String,Object>> getAttendRecodeList(PerAttendDateDTO dto) ;


    /**
     * 插入管理员修改的打卡记录
     * @author llc
     * @date 2018-12-06
     * @param dto
     * @return
     */
    int insertPerAttendRecord(PerAttendDateDTO dto) ;


    /**
     * 更新管理员修改的打卡记录
     * @author llc
     * @date 2018-12-06
     * @param dto
     * @return
     */
    int updatePerAttendRecord(PerAttendDateDTO dto) ;


    /**
     * 查询修改后的人员每日打卡情况
     * @author llc
     * @date 2018-12-07
     * @param dto
     * @return
     */
    List<PerAttendDateDTO> getAttendRecodeAgain(PerAttendDateDTO dto) ;

    /**
     * 更新人员日考勤统计
     * @author llc
     * @date 2018-12-08
     * @param countPerAttendDate
     * @return
     */

    int updateCountPerAttendDate(CountPerAttendDate countPerAttendDate) ;


    /**
     * 查询内勤统计记录
     * @author llc
     * @date 2019-01-04
     * @param perId
     * @param comId
     * @return
     */
    AppPerAttendCountResultDTO getInAttendCount(@Param("perId") Long perId, @Param("comId") Long comId, @Param("startDate")String startDate, @Param("endDate")String endDate) ;


    /**
     * 查询异常考勤信息
     * @author llc
     * @date 2019-01-04
     * @param perId
     * @param comId
     * @return
     */
    List<PerAttendDateDTO> getAbnormalAttendInfo(@Param("perId") Long perId,@Param("comId") Long comId,@Param("startDate")String startDate,@Param("endDate")String endDate) ;


    /**
     * 查询异常打卡记录
     * @author llc
     * @date 2019-01-04
     * @param perId
     * @param comId
     * @param list
     * @return
     */
    List<Map<String,String>> getAbnormalAttendRecord(@Param("perId") Long perId,@Param("comId") Long comId,@Param("list")List<PerAttendDateDTO> list) ;


    /**
     * 查询缺卡记录
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @param list
     * @return
     */
    List<Map<String,String>> getMissCardRecord(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate,
                                               @Param("list")List<PerAttendDateDTO> list) ;


    /**
     * 查询统计区间内的请假、加班情况
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @return
     */
    Map<String,Object> getLeaveAndOverTimeInfo(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate) ;


    /**
     * 查询统计区间内的考勤请假记录
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @return
     */
    List<Map<String,Object>> getAttendLeaveList(@Param("perId") Long perId,
                                               @Param("comId") Long comId,
                                               @Param("startDate")String startDate,
                                               @Param("endDate")String endDate) ;

    /**
     * 查询统计区间内的加班记录
     * @author llc
     * @date 2019-01-05
     * @param perId
     * @param comId
     * @param startDate
     * @param endDate
     * @return
     */
    List<Map<String,Object>> getOverTimeList(@Param("perId") Long perId,
                                             @Param("comId") Long comId,
                                             @Param("startDate")String startDate,
                                             @Param("endDate")String endDate) ;
}