package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.enterprise.company.ComBaseInfo;
import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.entity.system.ComDepart;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业基础信息
 *
 * @author zhangye
 * @since 2017-12-22 11:20:53
 */
public interface ComBaseInfoMapper extends CrudDao<ComBaseInfo> {

    ComBaseInfo selectByID(Long comId);

    /**
     * 根据公司ID获取部门人员通讯录
     *
     * @return java.util.Map
     * @Decription:
     * @author：wangjianchi
     * @method personByDepartId @date：2018/01/19 16:30 @params： * @param comID
     */
    List<Map> personByComId(ComDepart comDepart);

    /**
     * 获取公司名称
     *
     * @param comId
     * @return
     */
    String findComName(Long comId);
    /**
     * <b> 查询企业的 TreeCode</b>
     * @author ZXF
     * @create 2019/04/11 0011 15:02
     * @version
     * @注意事项 </b>
     */
    String findComTreeCode(Long comId);

    /**
     * <b> 根据城市获取保险规则 </b>
     * @author ZXF
     * @create 2019/02/20 0020 17:34
     * @version
     * @注意事项 </b>
     */
    String getContentByCity(@Param("city") Integer city, @Param("institutionType") String institutionType);

    /**
     * 检查公司名称是否被使用过
     *
     * @param comName
     * @return
     */
    int checkComName(@Param("comName") String comName, @Param("comId") Long comId);

    /**
     * 检查公司营业执照号是否被使用过
     *
     * @param comCerNo
     * @return
     */
    int checkComCerNo(@Param("comCerNo") String comCerNo, @Param("comBranchId") Long comBranchId);

    /**
     * 检查公司营业执照号是否被使用过
     *
     * @param comCerNo
     * @return
     */
    int checkLinkWithParentCom(@Param("comCerNo") String comCerNo, @Param("parentComId") Long parentComId,
                               @Param("comBranchId") Long comBranchId);

    /**
     * 修改分公司信息
     *
     * @param comBaseInfo
     * @return
     */
    int updateBranchCom(ComBaseInfo comBaseInfo);

    /**
     * 完成企业初始化
     * @return
     */
    int updateComInit(ComBaseInfo comBaseInfo);

    /**
     * 获取用户对应公司的注册地
     * @param perId
     * @return
     */
    Map<String,String> selectRegProvinceByPerId(@Param("perId")Long perId);


    /**
     * 获取人员上一家的企业注册省份
     * @param perId
     * @auth llc
     * @date 2019-09-03
     * @return
     */
    String getRegProvincePerId(@Param("perId")Long perId);

    List<String> getAllComId(@Param("institutionType")String institutionType);

    List<Map> getInfoByComIds(@Param("comIdList")List<String> comIdList);

    String getComAreaCode(@Param("comId") Long comId);

    int isOpenAccount(@Param("userName") String userName);
    int isBJLZ(@Param("userName") String userName);
    String getComIdByUserName(@Param("userName") String userName);

}