package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComAttendGroup;
import com.bcxin.oa.old.dto.ComAttendGroupDTO;
import com.bcxin.oa.old.common.CrudDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 企业考勤组
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface ComAttendGroupMapper extends CrudDao<ComAttendGroup> {

    /**
     * 考勤组分页
     *
     * @param comAttendGroupDTO
     * @return
     * @author zhongjianhui
     * @since 2018-02-28
     */
    List<Map<String,String>> pageForGroup(ComAttendGroupDTO comAttendGroupDTO);
    /**
     * 新增考勤组
     *
     * @param comAttendGroup
     * @return
     * @author zhangjianhua
     * @since 2018-02-26
     */
    int addAttendGroup(ComAttendGroup comAttendGroup);

    /**
     * 更新考勤组基本信息
     *
     * @param comAttendGroup
     * @return
     */
    int updateAttendGroup(ComAttendGroup comAttendGroup);


    /**
     * 更新旧的考勤组的生效截止时间
     *
     * @param paramMap
     * @return
     */
    int updateOldAttendGroup(Map<String,Object> paramMap);

    /**
     * 查询是否已经存在同名的考勤组记录
     *
     * @param dto
     * @return
     */
    int getExistsSameAttendGroupNameCount(ComAttendGroupDTO dto);


    /**
     * 删除考勤组
     *
     * @param attendGroupId
     * @param updateBy
     * @param updateTime
     * @return
     * by llc 2018-11-23
     */
    int deleteAttendGroupById(@Param(value = "attendGroupId") Long attendGroupId,
                              @Param(value = "updateBy") Long updateBy,
                              @Param(value = "updateTime") Date updateTime);

}