package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业考勤组考勤人员
 * 
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
@TableName("com_attend_per")
@Data
public class ComAttendPer extends BaseEntity<ComAttendPer> {
	private static final long serialVersionUID = 299846638L;

	/** 考勤人员ID */
	@ApiModelProperty(value = "考勤人员ID")
	private Long comAttendPerId;

	/** 考勤组ID */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getAttendGroupId() {
		return attendGroupId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	/** 生效开始时间 */
	@ApiModelProperty(value = "生效开始时间")
	private Date effectStartTime;

	/** 生效截止时间 */
	@ApiModelProperty(value = "生效截止时间")
	private Date effectEndTime;

}