package com.bcxin.oa.old.dto.app;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * APP考勤班次
 * 
 * @author zhangye
 *
 */
public class AppComAttendShiftDTO {

	/**
	 * 班次ID
	 */
	@ApiModelProperty(value = "班次ID")
	private Long shiftId;
	/**
	 * 考勤组ID
	 */
	@ApiModelProperty(value = "考勤组ID")
	private Long attendGroupId;

	/**
	 * 班次状态 (1：未开始，2：可上班打卡，3：可下班打卡，4：已结束)
	 */
	@ApiModelProperty(value = "班次状态")
	private int currentShiftType;
	/**
	 * 班次类别(1：周期排班制班，2：周期固定班，3：临时班，4：紧急班，5：自由班)
	 */
	@ApiModelProperty(value = "班次类别")
	private int shiftType;
	/**
	 * 班次名称
	 */
	@ApiModelProperty(value = "班次名称")
	private String shiftName;

	/**
	 * 班次时间
	 */
	@ApiModelProperty(value = "班次时间")
	private String shiftTime;

	/**
	 * 班次是几号
	 */
	@ApiModelProperty(value = "班次是几号")
	private int day;

	/**
	 * 当前打卡状态是否为早退（用在下班打卡是否填写离岗说明）
	 */
	@ApiModelProperty(value = "当前打卡状态是否为早退")
	private boolean dutyStatus;

	/**
	 * 班次日期
	 */
	@ApiModelProperty(value = "班次日期")
	private String shiftDate;
	/**
	 * 人员ID
	 */
	@ApiModelProperty(value = "人员ID")
	private Long perId;
	/**
	 * 考勤轮次列表
	 */
	@ApiModelProperty(value = "考勤轮次列表")
	private List<AppComAttendSmallShiftDTO> arrSmallShifts;

	/**
	 * 补卡项状态0：停用，1：启用
	 */
	@ApiModelProperty(value = "补卡项状态")
	private int isActive;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getShiftId() {
		return shiftId;
	}

	public void setShiftId(Long shiftId) {
		this.shiftId = shiftId;
	}

	public int getCurrentShiftType() {
		return currentShiftType;
	}

	public void setCurrentShiftType(int currentShiftType) {
		this.currentShiftType = currentShiftType;
	}

	public int getShiftType() {
		return shiftType;
	}

	public void setShiftType(int shiftType) {
		this.shiftType = shiftType;
	}

	public String getShiftName() {
		return shiftName;
	}

	public void setShiftName(String shiftName) {
		this.shiftName = shiftName;
	}

	public String getShiftTime() {
		return shiftTime;
	}

	public void setShiftTime(String shiftTime) {
		this.shiftTime = shiftTime;
	}

	public int getDay() {
		return day;
	}

	public void setDay(int day) {
		this.day = day;
	}

	public boolean isDutyStatus() {
		return dutyStatus;
	}

	public void setDutyStatus(boolean dutyStatus) {
		this.dutyStatus = dutyStatus;
	}

	public String getShiftDate() {
		return shiftDate;
	}

	public void setShiftDate(String shiftDate) {
		this.shiftDate = shiftDate;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	public void setPerId(Long perId) {
		this.perId = perId;
	}

	public List<AppComAttendSmallShiftDTO> getArrSmallShifts() {
		return arrSmallShifts;
	}

	public void setArrSmallShifts(List<AppComAttendSmallShiftDTO> arrSmallShifts) {
		this.arrSmallShifts = arrSmallShifts;
	}

	public Long getAttendGroupId() {
		return attendGroupId;
	}

	public void setAttendGroupId(Long attendGroupId) {
		this.attendGroupId = attendGroupId;
	}

	public int getIsActive() {
		return isActive;
	}

	public void setIsActive(int isActive) {
		this.isActive = isActive;
	}
}
