package com.bcxin.oa.old.dto;

import com.bcxin.oa.old.entity.task.ComTaskFeedback;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 任务反馈传输对象
 *
 * @ClassName: ComTaskFeedbackDto
 */
@Data
public class ComTaskFeedbackDto extends ComTaskFeedback {

    private static final long serialVersionUID = 1436771342382127740L;

    /**
     * 用户ID
     */
    private Long perId;
    /**
     * 头像
     */
    private String photoUrl;
    /**
     * 姓名
     */
    private String name;
    /**
     * 任务创建时间格式化
     */
    private String formatTime;

    /**
     * 任务执行情况Id集合(,分割)
     */
    @ApiModelProperty(value = "任务执行情况Id")
    private List<Long> taskImplementIdList;

    /**
     * 任务日期
     */
    @ApiModelProperty(value = "任务日期")
    private Date ImplementDate;


    @JsonSerialize(using = ToStringSerializer.class)
    public Long getPerId() {
        return perId;
    }

    public void setPerId(Long perId) {
        this.perId = perId;
    }

    public String getPhotoUrl() {
        return photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFormatTime() {
        return formatTime;
    }

    public void setFormatTime(String formatTime) {
        this.formatTime = formatTime;
    }
}
