package com.bcxin.oa.old.controller.attend;

import com.bcxin.oa.old.dto.ComAttendAddressDTO;
import com.bcxin.oa.old.dto.ComAttendGroupDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.attend.ComAttendGroupService;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.aspect.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangjianhua
 * @date 2018/02/26
 */
@RestController
@RequestMapping("/task/attendance/com-attend-group")
@Api(tags = { "" }, description = "考勤管理")
public class ComAttendGroupController extends BaseController {

	@Autowired
	private ComAttendGroupService comAttendGroupService;

	/**
	 * 考勤组分页
	 *
	 * @param dto
	 * @return
	 * @author zhongjianhui
	 * @date 2018/02/28
	 */
	@GetMapping(value = "/page-for-group")
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "考勤管理", title = "考勤组分页", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "考勤组分页", notes = "考勤组分页")
	public Result pageForGroup(ComAttendGroupDTO dto) {
		return comAttendGroupService.pageForGroup(dto).setBack(getRequest());
	}

	/**
	 * 进入考勤组-第一步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/in-first-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "进入考勤组-第一步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "进入考勤组-第一步", notes = "进入考勤组-第一步")
	public Result inFirstStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.inFirstStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 新增考勤组-第一步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/27
	 */
	@PostMapping(value = "/save-first-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "新增考勤组-第一步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "新增考组-第一步", notes = "新增考勤组-第一步")
	public Result saveFirstStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.saveFirstStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 进入考勤组-第二步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/in-second-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "进入考勤组-第二步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "进入考勤组-第二步", notes = "进入考勤组-第二步")
	public Result inSecondStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.inSecondStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 新增考勤组-第二步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/save-second-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "新增考勤组-第二步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "新增考勤组-第二步", notes = "新增考勤组-第二步")
	public Result saveSecondStepAttendGroup(ComAttendAddressDTO dto) throws BusinessException {
		return comAttendGroupService.saveSecondStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 校验考勤组人员
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/check_attend_per")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "校验考勤组人员", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "校验考勤组人员", notes = "校验考勤组人员")
	public Result checkAttendPer(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.checkAttendPer(dto).setBack(getRequest());
	}

	/**
	 * 进入考勤组-第三步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/in-third-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "进入考勤组-第三步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "进入考勤组-第三步", notes = "进入考勤组-第三步")
	public Result inThirdStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.inThirdStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 新增考勤组-第三步
	 *
	 * @param dto
	 * @return
	 * @author llc
	 * @date 2018/03/30
	 */
	@PostMapping(value = "/save-third-step-attend-group")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "新增考勤组-第三步", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "新增考勤组-第三步", notes = "新增考勤组-第三步")
	public Result saveThirdStepAttendGroup(ComAttendGroupDTO dto) throws BusinessException {
		return comAttendGroupService.saveThirdStepAttendGroup(dto).setBack(getRequest());
	}

	/**
	 * 删除考勤组
	 *
	 * @param comAttendGroupDTO
	 * @return
	 * @author wuxiaozhen
	 * @since 2018-03-01
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "考勤组管理", title = "删除考勤", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping(value = "delete")
	@ApiOperation(value = "删除考勤", httpMethod = "POST", notes = "删除考勤", response = ComAttendGroupDTO.class)
	public Result deleteByPrimaryKey(ComAttendGroupDTO comAttendGroupDTO) throws BusinessException {
		return comAttendGroupService.delete(comAttendGroupDTO).setBack(getRequest());
	}

	/**
	 * 定时器删除正式考勤组修改的考勤组中间表、考勤组人员校验表（最后一步未提交）
	 *
	 * @return
	 * @author llc
	 * @date 2018/09/29
	 */
	@PostMapping(value = "/del-mid-attend-by-task")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "考勤管理", title = "删除正式考勤组修改的考勤组中间表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "删除正式考勤组修改的考勤组中间表", notes = "删除正式考勤组修改的考勤组中间表")
	public Result deleteMidAttendByTask() throws BusinessException {
		return comAttendGroupService.deleteMidAttendByTask();
	}


	/**
	 * 内勤打卡提醒定时器
	 *
	 * @return
	 * @author llc
	 * @date 2019/01/10
	 */
	@PostMapping(value = "/attend-card-remind")
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "内勤打卡提醒", title = "内勤打卡提醒", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@ApiOperation(value = "内勤打卡提醒", notes = "内勤打卡提醒")
	public Result attendCardRemindJob() throws BusinessException {
		return comAttendGroupService.attendCardRemindJob();
	}

}
