package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.mapper.ComTaskImplementMapper;
import com.bcxin.oa.old.mapper.ComTaskMapper;
import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.dto.ComTaskImplementDto;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.service.common.CommonService;
import com.bcxin.oa.old.common.Result;
import org.apache.commons.lang3.StringUtils;
import com.bcxin.oa.old.common.utils.BBDService;
import com.bcxin.oa.old.common.CommonConst;
import com.github.pagehelper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * 任务轨迹
 *
 * @author zhangjianhua
 * @date 2018/4/16
 */
@Service
@Transactional
public class ComTaskTrackServiceImpl implements ComTaskTrackService {

	@Autowired
	private ComTaskImplementMapper comTaskImplementMapper;

	@Autowired
	private ComTaskMapper comTaskMapper;

	@Autowired
	private CommonService commonService;

	/**
	 * 查询任务轨迹
	 *
	 * @param comTaskImplementDto
	 * @return
	 * @throws BusinessException
	 */
	@Override
	public Result selectTaskTrack(ComTaskImplementDto comTaskImplementDto) throws BusinessException {

		if (comTaskImplementDto.getTaskImplementId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务执行情况Id不能为空");
		}
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(comTaskImplementDto.getTaskImplementId());
		if (comTaskImplement == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，轮次执行情况不存在");
		}
		ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplement.getComTaskId());
		try {
			String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
			String configURL = ""; // 公安子站服务器地址
			if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
			} else {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince());
			}
			/* 未配置子站 */
			if (StringUtil.isEmpty(configURL)) {
				throw new BusinessException(Result.BUSINESS_ERROR, "外勤所属城市暂未开放轨迹服务");
			}
			Result postResult = BBDService.listTaskTrack(comTaskImplementDto.getTaskImplementId().toString(),
					comTaskImplementDto.getSessionId(), configURL);
			if (postResult.getRetType().equals(Result.ERROR)) {
				throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，请稍后重试");
			} else {
				return postResult;
			}
		} catch (Exception e) {
			throw new BusinessException(Result.BUSINESS_ERROR, "查询任务轨迹失败，请稍后重试");
		}

	}

	/**
	 * 保存任务轨迹
	 *
	 * @param comTaskImplementDto
	 * @return
	 */
	@Override
	public Result saveTaskTrack(ComTaskImplementDto comTaskImplementDto) throws BusinessException {

		if (comTaskImplementDto.getTaskImplementId() == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "任务执行情况Id不能为空");
		}
		if (StringUtils.isEmpty(comTaskImplementDto.getAddressLongitude())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "经度不能为空");
		}
		if (StringUtils.isEmpty(comTaskImplementDto.getAddressLatitude())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "纬度不能为空");
		}
		ComTaskImplement comTaskImplement = comTaskImplementMapper
				.getByPrimaryKey(comTaskImplementDto.getTaskImplementId());
		if (comTaskImplement == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，轮次执行情况不存在");
		}
		ComTask comTask = comTaskMapper.getComTaskByPrimaryKey(comTaskImplement.getComTaskId());
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("sessionId", comTaskImplementDto.getSessionId());
		paramMap.put("taskFeedbackId", comTaskImplementDto.getTaskImplementId());// 任务执行情况Id
		paramMap.put("longitude", comTaskImplementDto.getAddressLongitude()); // 经度
		paramMap.put("latitude", comTaskImplementDto.getAddressLatitude()); // 纬度
		try {
			String open_substation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
			String configURL = ""; // 公安子站服务器地址
			if (StringUtils.isNotEmpty(open_substation) && open_substation.equals(CommonConst.Y)) {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
			} else {
				configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comTask.getProvince());
			}
			Result postResult = BBDService.saveTaskTrack(paramMap, configURL);
			if (postResult.getRetType().equals(Result.ERROR)) {
				throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，请稍后重试");
			} else {
				return postResult;
			}
		} catch (Exception e) {
			throw new BusinessException(Result.BUSINESS_ERROR, "保存任务轨迹失败，请稍后重试");
		}
	}
}
