package com.bcxin.oa.old.service.task;

import cn.hutool.core.text.StrSplitter;
import com.alibaba.fastjson.JSON;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.utils.ObjectUtils;
import com.bcxin.oa.old.common.utils.PageInfoUtils;
import com.bcxin.oa.old.mapper.*;
import com.bcxin.oa.old.entity.task.*;
import com.bcxin.oa.old.dto.*;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.*;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 人员排班
 *
 * @author zhangye
 * @since 2018-02-26 10:04:47
 */
@Service
@Transactional
public class ComTaskShiftServiceImpl implements ComTaskShiftService {

	@Resource
	private ComTaskShiftMapper comTaskShiftMapper;

	@Resource
	private ComTaskMapper comTaskMapper;

	@Resource
	private ComTaskSchedulCycleMapper comTaskSchedulCycleMapper;

	@Resource
	private ComTaskCycleShiftMapper comTaskCycleShiftMapper;

	@Resource
	private ComTaskAttendAddressMapper comTaskAttendAddressMapper;

	@Resource
	private IdWorker idWorker;

	/**
	 * 更新任务信息
	 *
	 * @param comTaskSchedulDTO
	 * @throws BusinessException
	 */
	private void updateComtask(ComTaskSchedulDTO comTaskSchedulDTO) throws BusinessException {

		ComTask comTask = comTaskMapper.getByPrimaryKey(comTaskSchedulDTO.getComTaskId());
		comTask.setAttendType(comTaskSchedulDTO.getAttendType());
		// 更新任务考勤类型
		int status = comTaskMapper.update(comTask);
		if (status <= 0) {
			throw new BusinessException(Result.ERROR, "更新任务信息失败");
		}
	}

	/**
	 * 添加默认班次信息
	 *
	 * @param comTaskSchedulDTO
	 * @throws BusinessException
	 */
	private void addComTaskSchedul(ComTaskSchedulDTO comTaskSchedulDTO) throws BusinessException {

		if (comTaskSchedulDTO.getShiftIdArray() != null && comTaskSchedulDTO.getShiftIdArray().length > 0) {

			List<ComTaskShift> listComTaskShift = new ArrayList<>();

			for (String shiftIdStr : comTaskSchedulDTO.getShiftIdArray()) {

				ComTaskShift comTaskShift = new ComTaskShift();

				comTaskShift.setCreateTime(comTaskSchedulDTO.getCreateTime());

				comTaskShift.setCreateBy(comTaskSchedulDTO.getCreateBy());

				comTaskShift.setUpdateTime(comTaskSchedulDTO.getUpdateTime());

				comTaskShift.setUpdateBy(comTaskSchedulDTO.getUpdateBy());

				comTaskShift.setComId(comTaskSchedulDTO.getComId());

				comTaskShift.setShiftId(Long.parseLong(shiftIdStr));

				comTaskShift.setComTaskId(comTaskSchedulDTO.getComTaskId());

				listComTaskShift.add(comTaskShift);
			}
			// 批量插入添加默认班次信息

			if(listComTaskShift.size() > 0 ) {
				int status2 = comTaskShiftMapper.batchInsertComTaskShift(listComTaskShift);

				if (status2 <= 0) {
					throw new BusinessException(Result.ERROR, "添加班次失败");
				}
			}
		} else {
			throw new BusinessException(Result.ERROR, "请选择默认班次");
		}
	}

	/**
	 * 周期排班设置
	 *
	 * @param comTaskSchedulDTO
	 * @throws BusinessException
	 */
	private void addTaskSchedulCycle(ComTaskSchedulDTO comTaskSchedulDTO) throws BusinessException {
		if (StringUtils.isNotEmpty(comTaskSchedulDTO.getComTaskSchedulCycleJson())) {

			List<ComTaskSchedulCycleDTO> list = JSON.parseArray(comTaskSchedulDTO.getComTaskSchedulCycleJson(),
					ComTaskSchedulCycleDTO.class);

			if (list != null && list.size() > 0) {

				List<ComTaskSchedulCycle> listComTaskSchedulCycle = new ArrayList<>();

				for (ComTaskSchedulCycleDTO comTaskSchedulCycleDTO : list) {

					ComTaskSchedulCycle comTaskSchedulCycle = new ComTaskSchedulCycle();

					ObjectUtils.copyProperties(comTaskSchedulCycle, comTaskSchedulDTO);

					comTaskSchedulCycle.setTaskSchedulCycleId(idWorker.nextId());

					comTaskSchedulCycle.setCycleName(comTaskSchedulCycleDTO.getCycleName());

					comTaskSchedulCycle.setCycleDays(comTaskSchedulCycleDTO.getCycleDays());

					comTaskSchedulCycle.setIsDelete("0");

					listComTaskSchedulCycle.add(comTaskSchedulCycle);

					// 添加任务排班周期所选班次
					if (comTaskSchedulCycleDTO.getShiftIdArrayUse() != null
							&& comTaskSchedulCycleDTO.getShiftIdArrayUse().length > 0) {

						List<ComTaskCycleShift> listComTaskCycleShift = new ArrayList<>();

						for (int i = 0; i < comTaskSchedulCycleDTO.getShiftIdArrayUse().length; i++) {

							ComTaskCycleShift comTaskCycleShift = new ComTaskCycleShift();

							ObjectUtils.copyProperties(comTaskCycleShift, comTaskSchedulCycle);

							comTaskCycleShift.setTaskSchedulCycleId(comTaskSchedulCycle.getTaskSchedulCycleId());

							if ("-1".equals(comTaskSchedulCycleDTO.getShiftIdArrayUse()[i])) {
								comTaskCycleShift.setIsRest("1");
							} else {
								comTaskCycleShift.setIsRest("0");
								comTaskCycleShift
										.setShiftId(Long.parseLong(comTaskSchedulCycleDTO.getShiftIdArrayUse()[i]));
							}
							comTaskCycleShift.setWhatDay(i + 1);

							listComTaskCycleShift.add(comTaskCycleShift);
						}
						// 批量插入任务排班周期所选班次
						int status3 = comTaskCycleShiftMapper.batchInsertComTaskCycleShift(listComTaskCycleShift);
						if (status3 <= 0) {
							throw new BusinessException(Result.ERROR, "添加任务排班周期所选班次失败");
						}
					} else {
						throw new BusinessException(Result.ERROR, "添加周期失败");
					}
				}
				// 批量添加周期基础信息
				int status2 = comTaskSchedulCycleMapper.batchInsertComTaskSchedulCycle(listComTaskSchedulCycle);

				if (status2 <= 0) {
					throw new BusinessException(Result.ERROR, "添加周期失败");
				}
			}
		}
	}

	/**
	 * 设置出勤地点
	 *
	 * @param comTaskSchedulDTO
	 * @throws BusinessException
	 */
	private void addTaskAttendAddress(ComTaskSchedulDTO comTaskSchedulDTO) throws BusinessException {
		if (StringUtils.isNotEmpty(comTaskSchedulDTO.getComTaskAttendAddressJson())) {

			List<ComTaskAttendAddress> listComTaskAttendAddress = new ArrayList<>();

			List<ComTaskAttendAddress> list = JSON.parseArray(comTaskSchedulDTO.getComTaskAttendAddressJson(),
					ComTaskAttendAddress.class);

			if (list != null && list.size() > 0) {

				for (ComTaskAttendAddress taskAttendAddress : list) {

					ComTaskAttendAddress comTaskAttendAddress = new ComTaskAttendAddress();
					// 拷贝基础信息
					ObjectUtils.copyProperties(comTaskAttendAddress, taskAttendAddress);

					comTaskAttendAddress.setComId(comTaskSchedulDTO.getComId());
					comTaskAttendAddress.setComTaskId(comTaskSchedulDTO.getComTaskId());
					comTaskAttendAddress.setTaskAttendAddressId(idWorker.nextId());
					comTaskAttendAddress.setCreateBy(comTaskSchedulDTO.getCreateBy());
					listComTaskAttendAddress.add(comTaskAttendAddress);
				}
				// 批量插入出勤地点
				int status4 = comTaskAttendAddressMapper.batchInsertAttendAddress(listComTaskAttendAddress);
				if (status4 <= 0) {
					throw new BusinessException(Result.ERROR, "请设置出勤地点失败");
				}
			} else {
				throw new BusinessException(Result.ERROR, "请设置出勤地点");
			}
		} else {
			throw new BusinessException(Result.ERROR, "请设置出勤地点");
		}
	}


	/**
	 * 获取未排班班次列表
	 *
	 * @param comTaskShift
	 * @author llc
	 * @date 2020-05-06
	 */
	@Override
	public Result getNoSchedulShiftList(ComTaskShift comTaskShift) throws BusinessException {

		if (comTaskShift.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		if (comTaskShift.getPageNumber() == null) {
			throw new BusinessException(Result.ERROR, "第几页不能为空");
		}
		if (comTaskShift.getPageSize() == null) {
			throw new BusinessException(Result.ERROR, "每页多少行不能为空");
		}
		PageHelper.startPage(comTaskShift.getPageNumber(), comTaskShift.getPageSize());
		/*** 查询未排班班次列表 ***/
		List<Map<String, String>> shiftList = comTaskShiftMapper.getNoSchedulShiftList(comTaskShift);
		PageInfoUtils pageInfo = new PageInfoUtils(shiftList);
		return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
	}


	/**
	 * 删除驻勤班次关联
	 *
	 * @param dto
	 * @author llc
	 * @date 2020-05-06
	 */
	@Override
	public Result deleteTaskShift(ComTaskShiftDto dto) throws BusinessException {

		if (dto.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		if (dto.getShiftIdStr() == null) {
			throw new BusinessException(Result.ERROR, "请选择需要删除的班次");
		}
		List<String> shiftIdStrList = StrSplitter.split(dto.getShiftIdStr(), ",", true, true);


		List<ComTaskShift> list = comTaskShiftMapper.getShiftListByTask(dto.getComTaskId());

		if(list != null && shiftIdStrList.size() == list.size()){
			throw new BusinessException(Result.ERROR, "请至少保留一个班次");
		}

		List<Long> shiftIdList = new ArrayList<>();

		for(String shiftIdStr : shiftIdStrList){
			shiftIdList.add(Long.parseLong(shiftIdStr));
		}
		comTaskShiftMapper.deleteTaskShift(dto.getComTaskId(),shiftIdList);
		return Result.success(Result.SUCCESS_MSG);
	}


	/**
	 * 获取未设置班次列表
	 *
	 * @param comTaskShift
	 * @author llc
	 * @date 2020-05-09
	 */
	@Override
	public Result getNoSetShiftList(ComTaskShift comTaskShift) throws BusinessException {

		if (comTaskShift.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		if (comTaskShift.getPageNumber() == null) {
			throw new BusinessException(Result.ERROR, "第几页不能为空");
		}
		if (comTaskShift.getPageSize() == null) {
			throw new BusinessException(Result.ERROR, "每页多少行不能为空");
		}
		PageHelper.startPage(comTaskShift.getPageNumber(), comTaskShift.getPageSize());
		/*** 查询未设置的班次列表 ***/
		List<Map<String, String>> shiftList = comTaskShiftMapper.getNoSetShiftList(comTaskShift);
		PageInfoUtils pageInfo = new PageInfoUtils(shiftList);
		return Result.success(Result.SUCCESS_QUERY_MSG, pageInfo);
	}


	/**
	 * 新增驻勤班次关联
	 * @param dto
	 * @author llc
	 * @date 2020-05-09
	 * @return
	 * @throws BusinessException
	 */
	@Override
	public Result addTaskShift(ComTaskShiftDto dto) throws BusinessException {

		if (dto.getComTaskId() == null) {
			throw new BusinessException(Result.ERROR, "驻勤ID不能为空");
		}
		if (StringUtil.isEmpty(dto.getShiftIdStr())) {
			throw new BusinessException(Result.ERROR, "请选择需要添加的班次");
		}
		List<String> shiftIdStrList = StrSplitter.split(dto.getShiftIdStr(), ",", true, true);

		List<ComTaskShift> comTaskShiftList = new ArrayList<>();
		for(String shiftIdStr : shiftIdStrList){
			ComTaskShift comTaskShift = new ComTaskShift();
			comTaskShift.setComTaskId(dto.getComTaskId());
			comTaskShift.setCreateTime(dto.getCreateTime());
			comTaskShift.setCreateBy(dto.getCreateBy());
			comTaskShift.setComId(dto.getComId());
			comTaskShift.setShiftId(Long.parseLong(shiftIdStr));
			comTaskShiftList.add(comTaskShift);
		}
		if(comTaskShiftList.size() >0 ) {
			comTaskShiftMapper.batchInsertComTaskShift(comTaskShiftList);
		}
		return Result.success(Result.SUCCESS_MSG);
	}


}
