package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.entity.task.ComTask;
import com.bcxin.oa.old.entity.task.ComTaskShift;
import com.bcxin.oa.old.dto.ComTaskDto;
import com.bcxin.oa.old.dto.ComTaskPerDTO;
import com.bcxin.oa.old.dto.ComTaskTempDTO;
import com.bcxin.oa.old.dto.ComTaskThreeDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.Result;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 任务
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskService {
    /**
     *
     * @Decription: 查询所有大类小类
     * @author：zhongjianhui
     * @method  listForTaskType
     * @date：2018/4/17 17:06
     * @params： * @param comTaskDto
     * @return com.bcxin.platform.util.Result
     */
    Result  treeForTaskType(ComTaskDto comTaskDto);

    /**
     * 分页查询任务列表
     *
     * @param comTaskDto
     * @return
     * @Title: pageTaskList
     * @Description:
     * @return: Result
     * @date: 2017年12月22日
     */
    Result pageTaskList(ComTaskDto comTaskDto);


    /**
     * 导出任务列表
     * @param dto
     * @author llc
     * @date 2020-04-07
     * @return
     * @throws BusinessException
     */
    Result exportTaskList(ComTaskDto dto, HttpServletResponse response) throws BusinessException;


    /**
     * 获取所属行业类型列表
     *
     * @return ComTaskDto
     */
    Result getIndustriesList(ComTaskDto comTaskDto);

    /**
     * 获取服务类型
     *
     * @return ComTaskDto
     */
    Result getServerTypeList(ComTaskDto comTaskDto);

    /**
     * @param comTaskTempDTO
     * @Author: zhongjianhui
     * @Description:任务获取第一步详情
     * @Date: 2018/03/08 14:05
     */
    Result getStepOneDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException;

    /**
     * @param comTaskDto
     * @Author: zhongjianhui
     * @Description:任务保存第一步详情
     * @Date: 2018/03/07 17:05
     */
    Result saveStepOneDetail(ComTaskDto comTaskDto) throws BusinessException;

    /**
     * @param comTaskTempDTO
     * @Author: zhongjianhui
     * @Description:任务获取第二步详情
     * @Date: 2018/03/07 14:05
     */
    Result getStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException;

    /**
     * @param comTaskTempDTO
     * @Author: zhongjianhui
     * @Description:任务保存第二步详情
     * @Date: 2018/03/07 17:05
     */
    Result saveStepTwoDetail(ComTaskTempDTO comTaskTempDTO) throws BusinessException;

    /**
     * @param comTaskThreeDTO
     * @Author: zhongjianhui
     * @Description:任务保存第三步详情
     * @Date: 2018/03/10 17:05
     */
    Result saveStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;

    /**
     * @param comTaskThreeDTO
     * @Author: zhongjianhui
     * @Description:任务获取第三步详情
     * @Date: 2018/03/15 14:05
     */
    Result getStepThreeDetail(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;


    /**
     * 根据id获取任务
     *
     * @param comTaskId
     * @return ComTaskDto
     */
    Result getTaskById(Long comTaskId);

    /**
     * <b> 根据任务id获取未投保的人员信息 </b>
     * @param comTaskThreeDTO
     * @author ZXF
     * @create 2018/11/09 0009 14:21
     * @version
     * @注意事项 </b>
     */
    Result getTaskUnInsPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;

    /**
     * <b> 根据任务id获取任务冲突投保人员列 </b>
     * @param comTaskThreeDTO
     * @author ZXF
     * @create 2018/11/09 0009 14:21
     * @version
     * @注意事项 </b>
     */
    Result getTaskConflictPerInfoList(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;



    /***
     * 获取任务成员名单 (任务详情的第3个tab)
     * @param comTaskThreeDTO
     * @return
     * @throws BusinessException
     * by llc 2018-09-20
     */

     Result getTaskPer(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;



    /**
     * 导出任务人员
     * @param dto
     * @author llc
     * @date 2019-11-29
     * @return
     * @throws BusinessException
     */
    Result exportTaskPer(ComTaskThreeDTO dto, HttpServletResponse response) throws BusinessException;


    /***
     * 获取任务负责人
     * @param comTask
     * @return
     * @throws BusinessException
     * by llc 2019-11-25
     */

    Result getTaskChargePer(ComTask comTask) throws BusinessException;


    /***
     * 修改任务负责人
     * @param comTask
     * @return
     * @throws BusinessException
     * by llc 2019-11-29
     */

    Result updateTaskChargePer(ComTask comTask) throws BusinessException;


    /***
     * 移除任务人员
     * @param dto
     * @return
     * @throws BusinessException
     * by llc 2019-11-29
     */

    Result removeTaskPer(ComTaskPerDTO dto) throws BusinessException;


    /***
     * 新增任务人员
     * @param dto
     * @return
     * @throws BusinessException
     * by llc 2019-12-02
     */

    Result addTaskPer(ComTaskPerDTO dto) throws BusinessException;


    /**
     * 这个方法很重要，替代了很多方法，注意。
     * 删除未生效任务
     *
     * @return
     * @throws BusinessException
     * @author zhangjianhua
     * @date 2018/04/09
     * @update by llc 2020-04-08
     */
    Result deleteTask(ComTaskThreeDTO comTaskThreeDTO) throws BusinessException;


    /**
     * 延长任务
     * @param comTask
     * @author llc
     * @date 2020-04-09
     */
    Result extendTask(ComTask comTask) throws BusinessException;



    /**
     * 延长任务
     * @param comTask
     * @author llc
     * @date 2020-04-09
     */
    Result endTask(ComTask comTask) throws BusinessException;

    /**
     * 定时修改任务状态
     *
     * @return
     * @throws BusinessException
     */
    Result changeTaskStatus() throws BusinessException;


    /**
     * 外勤打卡提醒定时器
     *
     * @return
     * @author llc
     * @date 2019-01-12
     */
    Result taskCardRemindJob() throws BusinessException;


    /**
     * 驻勤到期提醒定时器
     *
     * @return
     * @author llc
     * @date 2020-04-24
     */
    Result taskExpireRemind() throws BusinessException;

    /**
     * 初始化外勤打卡
     * @param comId
     * @param comTask
     * @param shiftList
     */
    void initTaskRemind(Long comId, ComTask comTask, List<ComTaskShift> shiftList);


    /**
     * 检测合同是否关联了任务
     * @param dto
     * @author llc
     * @date 2019-05-15
     */
    Result checkRelateTaskByContractId(ComTaskDto dto);


    /**
     * 获取公司任务驻勤点类型
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    Result getComtaskStationType(ComTask comTask) throws BusinessException;

    /**
     * 防控指挥获取任务列表
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    Result getComTaskList(ComTask comTask) throws BusinessException;


    /**
     * 防控指挥获取任务人员位置
     *
     * @return
     * @author llc
     * @date 2019-11-01
     */
    Result getComTaskPerLocation(ComTask comTask) throws BusinessException;

    /**
     * 驻勤点批量删除
     * @return
     */
    Result deleteBatchComTask(ComTaskDto comTaskDto);


    /**
     * 通过合同ID查找驻勤点
     *
     * @return
     * @author llc
     * @date 2020-06-10
     */
    Result getTaskListByContractId(ComTask comTask) throws BusinessException;

    /**
     * 公安获取任务驻勤点类型
     *
     * @return
     * @author llc
     * @date 2020-07-02
     */
    Result policeGetTaskStationType(ComTask comTask) throws BusinessException;

    /**
     * 公安防控指挥获取任务列表
     *
     * @return
     * @author llc
     * @date 2020-07-02
     */
    Result policeGetTaskList(ComTaskDto dto) throws BusinessException;


    /**
     * 公安防控指挥获取任务位置列表
     *
     * @return
     * @author llc
     * @date 2020-07-09
     */
    Result policeGetTaskLocationList(ComTaskDto dto) throws BusinessException;

    /**
     * 公安防控指挥获取任务信息
     *
     * @return
     * @author llc
     * @date 2020-07-09
     */
    Result policeGetTaskById(ComTaskDto dto) throws BusinessException;


}