package com.bcxin.oa.old.service.task;

import com.bcxin.oa.old.mapper.ComTaskFeedbackMapper;
import com.bcxin.oa.old.mapper.ComTaskImplementMapper;
import com.bcxin.oa.old.entity.task.ComTaskFeedback;
import com.bcxin.oa.old.entity.task.ComTaskImplement;
import com.bcxin.oa.old.dto.app.AppComTaskFeedbackDTO;
import com.bcxin.oa.old.common.exception.BusinessException;
import com.bcxin.oa.old.common.utils.IdWorker;
import com.bcxin.oa.old.common.Result;
import org.apache.commons.lang3.StringUtils;
import com.bcxin.oa.old.common.DictConst;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务反馈记录
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional
public class ComTaskFeedbackServiceImpl implements ComTaskFeedbackService {
	@Resource
	private ComTaskFeedbackMapper comTaskFeedbackMapper;
	@Resource
	private ComTaskImplementMapper comTaskImplementMapper;
	@Resource
	private IdWorker idWorker;
	/**
	 * APP-查询任务日志记录
	 *
	 * @param appComTaskFeedbackDtoParam
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/14
	 */
	@Override
	public Result listComTaskFeedback(AppComTaskFeedbackDTO appComTaskFeedbackDtoParam) {
		List<ComTaskFeedback> comTaskFeedbackList = new ArrayList<ComTaskFeedback>();
		List<Long> list = appComTaskFeedbackDtoParam.getTaskImplementIdList();
		if (list != null && list.size() > 0) {
			comTaskFeedbackList = comTaskFeedbackMapper.selectComTaskFeedback(list);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comTaskFeedbackList);
	}

	/**
	 * APP-添加任务日志记录
	 *
	 * @param appComTaskFeedbackDto
	 * @return
	 * @author zhangjianhua
	 * @date 2018/03/23
	 */
	@Override
	public Result saveComTaskFeedBack(AppComTaskFeedbackDTO appComTaskFeedbackDto) throws BusinessException {
		Long taskImplementId = appComTaskFeedbackDto.getTaskImplementId();
		if (taskImplementId == null) {
			throw new BusinessException(Result.BUSINESS_ERROR, "添加任务日志记录失败:任务执行情况ID不能为空");
		}
		if (StringUtils.isEmpty(appComTaskFeedbackDto.getFeedbackContent())) {
			throw new BusinessException(Result.BUSINESS_ERROR, "添加任务日志记录失败:反馈日志不能为空");
		}
		ComTaskImplement comTaskImplement = comTaskImplementMapper.getByPrimaryKey(taskImplementId);
		appComTaskFeedbackDto.setComTaskId(comTaskImplement.getComTaskId());
		appComTaskFeedbackDto.setTaskFeedbackId(idWorker.nextId());
		appComTaskFeedbackDto.setDutyState(DictConst.DUTYSTATE_ZC);
		appComTaskFeedbackDto.setFeedbackDates(new Date());
		int status = comTaskFeedbackMapper.insert(appComTaskFeedbackDto);
		if (status <= 0) {
			throw new BusinessException(Result.BUSINESS_ERROR, "添加任务日志记录失败，请稍后重试");
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * 查询任务日志记录
	 *
	 * @param comTaskImplement
	 * @return
	 */
	@Override
	public Result listTaskFeedback(ComTaskImplement comTaskImplement) {

		List<ComTaskFeedback> comTaskFeedbackList = new ArrayList<>();

		List<Long> list = comTaskImplementMapper.listTaskImplementId(comTaskImplement);

		if (list != null && list.size() > 0) {
			comTaskFeedbackList = comTaskFeedbackMapper.selectComTaskFeedback(list);
		}
		return Result.success(Result.SUCCESS_QUERY_MSG, comTaskFeedbackList);

	}
}